/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.resources.Project;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.maven.MavenAnalyzer;

public class MavenFileSensor
implements Sensor {
    private final FileSystem fs;
    private final FilePredicate pomFilePredicate;
    private final SonarComponents sonarComponents;

    public MavenFileSensor(SonarComponents sonarComponents, FileSystem fs) {
        this.fs = fs;
        this.pomFilePredicate = fs.predicates().matchesPathPattern("**/pom.xml");
        this.sonarComponents = sonarComponents;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fs.hasFiles(this.pomFilePredicate);
    }

    public void analyse(Project module, SensorContext context) {
        this.sonarComponents.registerCheckClasses("squid", CheckList.getMavenChecks());
        new MavenAnalyzer(this.sonarComponents, this.sonarComponents.checkClasses()).scan(this.getPomFiles());
    }

    private Iterable<File> getPomFiles() {
        return this.fs.files(this.pomFilePredicate);
    }

    public String toString() {
        return MavenFileSensor.class.getSimpleName();
    }
}

