/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1125", name="Literal boolean values should not be used in condition expressions", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanEqualityComparisonCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove the literal \"%s\" boolean value.";

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.visitExpression(tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            this.visitExpression(tree.leftOperand());
            this.visitExpression(tree.rightOperand());
        }
        super.visitBinaryExpression(tree);
    }

    private void visitExpression(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            this.visitExpression(((ParenthesisedExpressionTree)expression).expression());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            String message = String.format(MESSAGE, ((LiteralTree)expression).value());
            this.addLineIssue((Tree)expression, message);
        }
    }
}

