/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3403", name="The identity operator (\"===\") should not be used with dissimilar types", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class DifferentTypesComparisonCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"%s\" check; it will always be false. Did you mean to use \"%s\"?";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO})) {
            Type leftOperandType = tree.leftOperand().types().getUniqueKnownType();
            Type rightOperandType = tree.rightOperand().types().getUniqueKnownType();
            if (leftOperandType != null && rightOperandType != null && leftOperandType.kind() != rightOperandType.kind()) {
                boolean bothObjects;
                boolean bl = bothObjects = DifferentTypesComparisonCheck.isObjectType(leftOperandType) && DifferentTypesComparisonCheck.isObjectType(rightOperandType);
                if (!bothObjects) {
                    this.raiseIssue(tree);
                }
            }
        }
    }

    private static boolean isObjectType(Type type) {
        Type.Kind kind = type.kind();
        return kind != Type.Kind.NUMBER && kind != Type.Kind.STRING && kind != Type.Kind.BOOLEAN;
    }

    private void raiseIssue(BinaryExpressionTree tree) {
        String operator = tree.operator().text();
        String message = String.format(MESSAGE, operator, operator.substring(0, operator.length() - 1));
        this.addIssue((Tree)tree.operator(), message).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
    }
}

