/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3003", name="Comparison operators should not be used with strings", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class StringsComparisonCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Convert operands of this use of \"%s\" to number type.";
    private static final Tree.Kind[] RELATIVE_OPERATIONS = new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(RELATIVE_OPERATIONS) && StringsComparisonCheck.isString(tree.leftOperand()) && StringsComparisonCheck.isString(tree.rightOperand())) {
            this.raiseIssue(tree);
        }
        super.visitBinaryExpression(tree);
    }

    private void raiseIssue(BinaryExpressionTree tree) {
        String message = String.format(MESSAGE, tree.operator().text());
        this.addIssue((Tree)tree.operator(), message).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
    }

    private static boolean isString(ExpressionTree expression) {
        Type type = expression.types().getUniqueKnownType();
        return type != null && type.kind() == Type.Kind.STRING;
    }
}

