/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="DuplicatePropertyName", name="Property names should not be duplicated within an object literal", priority=Priority.CRITICAL, tags={"bug", "pitfall"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class DuplicatePropertyNameCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Rename or remove duplicate property name '%s'.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        HashMap<String, Tree> keys = new HashMap<String, Tree>();
        for (Tree property : tree.properties()) {
            if (property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY})) {
                this.visitPairProperty(keys, (PairPropertyTree)property);
            }
            if (!property.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) continue;
            IdentifierTree identifier = (IdentifierTree)property;
            this.addKey(keys, identifier.name(), (Tree)((IdentifierTree)property));
        }
        super.visitObjectLiteral(tree);
    }

    private void visitPairProperty(Map<String, Tree> keys, PairPropertyTree pairProperty) {
        Tree key = pairProperty.key();
        if (key.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = ((LiteralTree)key).value();
            value = value.substring(1, value.length() - 1);
            this.addKey(keys, value, pairProperty.key());
        }
        if (key.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME})) {
            this.addKey(keys, ((IdentifierTree)key).name(), pairProperty.key());
        }
        if (key.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            this.addKey(keys, ((LiteralTree)key).value(), pairProperty.key());
        }
    }

    private void addKey(Map<String, Tree> keys, String key, Tree keyTree) {
        Tree duplicated = keys.get(EscapeUtils.unescape(key));
        if (duplicated != null) {
            this.addIssue(keyTree, String.format(MESSAGE, key)).secondary(duplicated);
        } else {
            keys.put(key, keyTree);
        }
    }
}

