/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="ElseIfWithoutElse", name="\"if ... else if\" constructs shall be terminated with an \"else\" clause", priority=Priority.MAJOR, tags={"cert", "misra"})
@SqaleConstantRemediation(value="5min")
public class ElseIfWithoutElseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add the missing \"else\" clause.";

    public void visitElseClause(ElseClauseTree tree) {
        IfStatementTreeImpl ifStmt;
        if (tree.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !(ifStmt = (IfStatementTreeImpl)tree.statement()).hasElse()) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree.elseKeyword(), (Tree)ifStmt.ifKeyword(), MESSAGE)));
        }
        super.visitElseClause(tree);
    }
}

