/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractSymbolNameCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="FutureReservedWords", name="\"future reserved words\" should not be used as identifiers", priority=Priority.CRITICAL, tags={"lock-in", "pitfall"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class FutureReservedWordsCheck
extends AbstractSymbolNameCheck {
    private static final String MESSAGE = "Rename \"%s\" identifier to prevent potential conflicts with future evolutions of the JavaScript language.";
    private static final List<String> FUTURE_RESERVED_WORDS = ImmutableList.of((Object)"implements", (Object)"interface", (Object)"package", (Object)"private", (Object)"protected", (Object)"public", (Object)"enum", (Object)"class", (Object)"const", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "let", "static", "yield", "await"});

    @Override
    List<String> illegalNames() {
        return FUTURE_RESERVED_WORDS;
    }

    @Override
    String getMessage(Symbol symbol) {
        return String.format(MESSAGE, symbol.name());
    }
}

