/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="NestedIfDepth", name="Control flow statements \"if\", \"for\", \"while\", \"switch\" and \"try\" should not be nested too deeply", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleConstantRemediation(value="10min")
public class NestedControlFlowDepthCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Refactor this code to not nest more than %s if/for/while/switch/try statements.";
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    private Deque<SyntaxToken> stack = new ArrayDeque<SyntaxToken>();
    @RuleProperty(key="maximumNestingLevel", description="Maximum allowed \"if/for/while/switch/try\" statements nesting depth", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public void visitScript(ScriptTree tree) {
        this.stack.clear();
        super.visitScript(tree);
    }

    public void visitIfStatement(IfStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.ifKeyword());
        this.visitIf(tree);
        this.decreaseNestedLevel();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.forKeyword());
        super.visitForStatement(tree);
        this.decreaseNestedLevel();
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.forKeyword());
        super.visitForObjectStatement(tree);
        this.decreaseNestedLevel();
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.whileKeyword());
        super.visitWhileStatement(tree);
        this.decreaseNestedLevel();
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.doKeyword());
        super.visitDoWhileStatement(tree);
        this.decreaseNestedLevel();
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.switchKeyword());
        super.visitSwitchStatement(tree);
        this.decreaseNestedLevel();
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.increaseAndCheckNestedLevel(tree.tryKeyword());
        super.visitTryStatement(tree);
        this.decreaseNestedLevel();
    }

    private void increaseAndCheckNestedLevel(SyntaxToken token) {
        if (this.stack.size() == this.getMaximumNestingLevel()) {
            PreciseIssue issue = this.addIssue((Tree)token, String.format(MESSAGE, this.getMaximumNestingLevel()));
            this.stack.forEach(t -> issue.secondary((Tree)t, "Nesting +1"));
        }
        this.stack.push(token);
    }

    private void decreaseNestedLevel() {
        this.stack.pop();
    }

    private void visitIf(IfStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.statement());
        ElseClauseTree elseClauseTree = tree.elseClause();
        if (tree.elseClause() != null && elseClauseTree.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.visitIf((IfStatementTree)((IfStatementTreeImpl)tree.elseClause().statement()));
        } else {
            this.scan((Tree)tree.elseClause());
        }
    }
}

