/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2259", name="Properties of variables with \"null\" or \"undefined\" values should not be accessed", priority=Priority.CRITICAL, tags={"bug", "cert", "cwe", "owasp-a1", "owasp-a2", "owasp-a6", "security"})
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class NullDereferenceCheck
extends SeCheck {
    private static final String MESSAGE = "TypeError can be thrown as \"%s\" might be null or undefined here.";
    private Set<Symbol> hasIssue;

    public void startOfExecution(Scope functionScope) {
        this.hasIssue = new HashSet<Symbol>();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        Constraint constraint;
        ExpressionTree object = NullDereferenceCheck.getObject(element);
        Symbol symbol = NullDereferenceCheck.getSymbol(object);
        if (symbol != null && (constraint = currentState.getConstraint(symbol)) != null && constraint.nullability() == Nullability.NULL && !this.hasIssue.contains(symbol)) {
            this.addIssue((Tree)object, String.format(MESSAGE, symbol.name()));
            this.hasIssue.add(symbol);
        }
    }

    private static Symbol getSymbol(@Nullable ExpressionTree object) {
        if (object != null && object.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)object).symbol();
        }
        return null;
    }

    @Nullable
    private static ExpressionTree getObject(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            return ((MemberExpressionTree)element).object();
        }
        return null;
    }
}

