/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2819", name="Cross-document messaging domains should be carefully restricted", priority=Priority.CRITICAL, tags={"html5", "security", "owasp-a3"})
@SqaleConstantRemediation(value="10min")
public class PostMessageCheck
extends DoubleDispatchVisitorCheck {
    private static final String POST_MESSAGE = "postMessage";
    private static final String MESSAGE = "Make sure this cross-domain message is being sent to the intended domain.";

    public void visitCallExpression(CallExpressionTree tree) {
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            boolean isWindow;
            DotMemberExpressionTree callee = (DotMemberExpressionTree)tree.callee();
            boolean bl = isWindow = callee.object().types().contains(Type.Kind.WINDOW) || PostMessageCheck.hasWindowLikeName(callee.object());
            if (isWindow && CheckUtils.asString((Tree)callee.property()).equals(POST_MESSAGE)) {
                this.addIssue((Tree)callee.property(), MESSAGE);
            }
        }
        super.visitCallExpression(tree);
    }

    private static boolean hasWindowLikeName(ExpressionTree tree) {
        String str = CheckUtils.asString((Tree)tree);
        return str.contains("window") || str.contains("Window");
    }
}

