/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2432", name="Setters should not return values", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class ReturnInSetterCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this return statement.";
    private final DoubleDispatchVisitorCheck forbiddenReturnVisitor = new ForbiddenReturnVisitor();

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SET_METHOD})) {
            tree.body().accept((DoubleDispatchVisitor)this.forbiddenReturnVisitor);
        }
        super.visitMethodDeclaration(tree);
    }

    private class ForbiddenReturnVisitor
    extends DoubleDispatchVisitorCheck {
        private ForbiddenReturnVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression() != null) {
                ReturnInSetterCheck check = ReturnInSetterCheck.this;
                check.addIssue((Tree)tree, ReturnInSetterCheck.MESSAGE);
            }
            super.visitReturnStatement(tree);
        }
    }
}

