/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1126", name="Return of boolean expressions should not be wrapped into an \"if-then-else\" statement", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleConstantRemediation(value="2min")
public class ReturnOfBooleanExpressionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace this if-then-else statement by a single return statement.";

    public void visitIfStatement(IfStatementTree tree) {
        if (tree.elseClause() != null && ReturnOfBooleanExpressionCheck.returnsBoolean(tree.elseClause().statement()) && ReturnOfBooleanExpressionCheck.returnsBoolean(tree.statement())) {
            this.addIssue((Tree)tree.ifKeyword(), MESSAGE);
        }
        this.visitIf(tree);
    }

    public static boolean returnsBoolean(StatementTree statement) {
        return ReturnOfBooleanExpressionCheck.isBlockReturningBooleanLiteral(statement) || ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral(statement);
    }

    public static boolean isBlockReturningBooleanLiteral(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statement;
            return block.statements().size() == 1 && ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral((StatementTree)block.statements().get(0));
        }
        return false;
    }

    public static boolean isSimpleReturnBooleanLiteral(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ExpressionTree returnExpr = ((ReturnStatementTree)statement).expression();
            return returnExpr != null && returnExpr.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL});
        }
        return false;
    }

    private void visitIf(IfStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.statement());
        ElseClauseTree elseClauseTree = tree.elseClause();
        if (tree.elseClause() != null && elseClauseTree.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.visitIf((IfStatementTree)((IfStatementTreeImpl)tree.elseClause().statement()));
        } else {
            this.scan((Tree)tree.elseClause());
        }
    }
}

