/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2549", name="The \"changed\" property should not be manipulated directly", priority=Priority.CRITICAL, tags={"backbone", "bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class BackboneChangedIsUsedCheck
extends BaseTreeVisitor {
    private static final String CHANGED = "changed";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && BackboneChangedIsUsedCheck.isChangedPropertyAccess((DotMemberExpressionTree)tree.variable())) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Remove this update of the \"changed\" property.");
        }
        super.visitAssignmentExpression(tree);
    }

    private static boolean isChangedPropertyAccess(DotMemberExpressionTree tree) {
        return tree.property().name().equals(CHANGED) && tree.object().types().contains(Type.Kind.BACKBONE_MODEL_OBJECT);
    }
}

