/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S878", name="Comma operator should not be used", priority=Priority.MAJOR, tags={"misra"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommaOperatorUseCheck
extends BaseTreeVisitor {
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            super.visitBinaryExpression(tree);
            return;
        }
        List<ExpressionTree> expressions = CommaOperatorUseCheck.getAllSubExpressions(tree);
        String message = expressions.size() > 2 ? "Remove use of all comma operators in this expression." : "Remove use of this comma operator.";
        this.getContext().addIssue((JavaScriptCheck)this, (Tree)CommaOperatorUseCheck.getFirstComma(tree), message);
        for (ExpressionTree expression : expressions) {
            super.scan((Tree)expression);
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        this.visitPossibleException(tree.init());
        super.scan((Tree)tree.condition());
        this.visitPossibleException((Tree)tree.update());
        super.scan((Tree)tree.statement());
    }

    private void visitPossibleException(@Nullable Tree tree) {
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            List<ExpressionTree> expressions = CommaOperatorUseCheck.getAllSubExpressions((BinaryExpressionTree)tree);
            for (ExpressionTree expression : expressions) {
                super.scan((Tree)expression);
            }
        } else {
            super.scan(tree);
        }
    }

    private static List<ExpressionTree> getAllSubExpressions(BinaryExpressionTree tree) {
        LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
        result.add(tree.rightOperand());
        ExpressionTree currentExpression = tree.leftOperand();
        while (currentExpression.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            result.add(((BinaryExpressionTree)currentExpression).rightOperand());
            currentExpression = ((BinaryExpressionTree)currentExpression).leftOperand();
        }
        result.add(currentExpression);
        return result;
    }

    private static SyntaxToken getFirstComma(BinaryExpressionTree tree) {
        SyntaxToken result = tree.operator();
        ExpressionTree currentExpression = tree.leftOperand();
        while (currentExpression.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            result = ((BinaryExpressionTree)currentExpression).operator();
            currentExpression = ((BinaryExpressionTree)currentExpression).leftOperand();
        }
        return result;
    }
}

