/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="FunctionDeclarationsWithinBlocks", name="Function declarations should not be made within blocks", priority=Priority.MAJOR, tags={"cross-browser", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class FunctionDeclarationsWithinBlocksCheck
extends BaseTreeVisitor {
    public void visitBlock(BlockTree tree) {
        for (StatementTree stmt : tree.statements()) {
            if (!stmt.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION})) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)stmt, "Do not use function declarations within blocks.");
        }
        super.visitBlock(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        if (tree.conciseBody().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.scan(((BlockTree)tree.conciseBody()).statements());
        } else {
            super.visitArrowFunction(tree);
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan(tree.body().statements());
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan(tree.body().statements());
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan(tree.body().statements());
    }
}

