/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="HtmlComments", name="HTML-style comments should not be used", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class HtmlCommentsCheck
extends SubscriptionBaseTreeVisitor {
    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            if (!trivia.text().startsWith("<!--")) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)trivia, "Replace this HTML-style comment by a standard comment");
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }
}

