/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1656", name="Variables should not be self-assigned", priority=Priority.MAJOR, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="3min")
public class SelfAssignmentCheck
extends BaseTreeVisitor {
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)tree.expression())) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Remove or correct this useless self-assignment.");
        }
        super.visitAssignmentExpression(tree);
    }
}

