/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1301", name="\"switch\" statements should have at least 3 \"case\" clauses", priority=Priority.MINOR, tags={"misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchWithNotEnoughCaseCheck
extends BaseTreeVisitor {
    public void visitSwitchStatement(SwitchStatementTree tree) {
        if (tree.cases().size() < 3) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Replace this \"switch\" statement with \"if\" statements to increase readability.");
        }
        super.visitSwitchStatement(tree);
    }
}

