/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S104", name="Files should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1h")
public class TooManyLinesInFileCheck
extends SubscriptionBaseTreeVisitor {
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", description="Maximum authorized lines in a file.", defaultValue="1000")
    public int maximum = 1000;

    public void visitNode(Tree tree) {
        if (!((InternalSyntaxToken)tree).isEOF()) {
            return;
        }
        SyntaxToken token = (SyntaxToken)tree;
        int lines = token.line();
        if (lines > this.maximum) {
            this.getContext().addFileIssue((JavaScriptCheck)this, String.format("File \"%s\" has %d lines, which is greater than %d authorized. Split it into smaller files.", this.getContext().getFile().getName(), lines, this.maximum));
        }
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }
}

