/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TrailingComma", name="Trailing commas should not be used", priority=Priority.BLOCKER, tags={"cross-browser"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommaCheck
extends BaseTreeVisitor {
    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.check((Tree)tree, tree.properties());
        super.visitObjectLiteral(tree);
    }

    public void visitArrayLiteral(ArrayLiteralTree tree) {
        this.check((Tree)tree, tree.elements());
        super.visitArrayLiteral(tree);
    }

    private void check(Tree tree, SeparatedList<?> separatedList) {
        int listSize = separatedList.size();
        if (listSize > 0 && listSize == separatedList.getSeparators().size()) {
            this.getContext().addIssue((JavaScriptCheck)this, tree, "Avoid trailing comma in array and object literals.");
        }
    }
}

