/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractSymbolNameCheck;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2137", name="Local variables should not shadow \"undefined\"", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class UndefinedShadowingCheck
extends AbstractSymbolNameCheck {
    private static final String MESSAGE = "Rename this variable.";

    @Override
    List<String> illegalNames() {
        return ImmutableList.of((Object)"undefined");
    }

    @Override
    String getMessage(Symbol symbol) {
        return MESSAGE;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getIllegalSymbols()) {
            if (symbol.scope().isGlobal() || !symbol.is(Symbol.Kind.VARIABLE)) continue;
            this.raiseIssuesOnDeclarations((JavaScriptCheck)this, symbol, MESSAGE);
        }
    }
}

