/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2703", name="Variables should always be declared with \"var\"", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class VariableDeclarationWithoutVarCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Add the \"var\" keyword to this declaration of \"%s\".";

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getContext().getSymbolModel().getSymbols(Symbol.Kind.VARIABLE)) {
            if (symbol.builtIn()) continue;
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            return;
        }
        if (!symbol.usages().isEmpty()) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)((Usage)symbol.usages().iterator().next()).identifierTree(), String.format(MESSAGE, symbol.name()));
        }
    }
}

