/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import java.util.HashSet;
import java.util.LinkedList;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.ClassType;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierListTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxJavaScriptExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSpreadAttributeTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class HighlightSymbolTableBuilder {
    private HighlightSymbolTableBuilder() {
    }

    public static Symbolizable.SymbolTable build(Symbolizable symbolizable, JavaScriptVisitorContext context) {
        Symbolizable.SymbolTableBuilder builder = symbolizable.newSymbolTableBuilder();
        HashSet<ClassType> classTypes = new HashSet<ClassType>();
        for (org.sonar.plugins.javascript.api.symbols.Symbol symbol : context.getSymbolModel().getSymbols()) {
            Type classType;
            HighlightSymbolTableBuilder.highlightSymbol(builder, symbol);
            if (symbol.kind() != Symbol.Kind.CLASS || (classType = symbol.types().getUniqueType(Type.Kind.CLASS)) == null) continue;
            classTypes.add((ClassType)classType);
        }
        for (ClassType classType : classTypes) {
            for (org.sonar.plugins.javascript.api.symbols.Symbol symbol : classType.properties()) {
                HighlightSymbolTableBuilder.highlightSymbol(builder, symbol);
            }
        }
        new BracesVisitor(builder).scanTree(context);
        return builder.build();
    }

    private static void highlightSymbol(Symbolizable.SymbolTableBuilder builder, org.sonar.plugins.javascript.api.symbols.Symbol symbol) {
        if (!symbol.usages().isEmpty()) {
            LinkedList<Usage> usagesList = new LinkedList<Usage>(symbol.usages());
            InternalSyntaxToken token = (InternalSyntaxToken)((Usage)usagesList.get(0)).identifierTree().identifierToken();
            Symbol reference = HighlightSymbolTableBuilder.getHighlightedSymbol(builder, token);
            for (int i = 1; i < usagesList.size(); ++i) {
                builder.newReference(reference, HighlightSymbolTableBuilder.getToken(((Usage)usagesList.get(i)).identifierTree()).startIndex());
            }
        }
    }

    private static Symbol getHighlightedSymbol(Symbolizable.SymbolTableBuilder builder, InternalSyntaxToken token) {
        int startOffset = token.startIndex();
        int endOffset = token.toIndex();
        return builder.newSymbol(startOffset, endOffset);
    }

    private static InternalSyntaxToken getToken(IdentifierTree identifierTree) {
        return (InternalSyntaxToken)identifierTree.identifierToken();
    }

    private static class BracesVisitor
    extends DoubleDispatchVisitor {
        private final Symbolizable.SymbolTableBuilder builder;

        BracesVisitor(Symbolizable.SymbolTableBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void visitBlock(BlockTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitBlock(tree);
        }

        @Override
        public void visitObjectLiteral(ObjectLiteralTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitObjectLiteral(tree);
        }

        @Override
        public void visitClass(ClassTree tree) {
            this.highlightBraces(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken());
            super.visitClass(tree);
        }

        @Override
        public void visitTemplateExpression(TemplateExpressionTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitTemplateExpression(tree);
        }

        @Override
        public void visitSpecifierList(SpecifierListTree tree) {
            this.highlightBraces(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken());
            super.visitSpecifierList(tree);
        }

        @Override
        public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitObjectBindingPattern(tree);
        }

        @Override
        public void visitJsxSpreadAttribute(JsxSpreadAttributeTree tree) {
            this.highlightBraces(tree.lCurlyBraceToken(), tree.rCurlyBraceToken());
            super.visitJsxSpreadAttribute(tree);
        }

        @Override
        public void visitJsxJavaScriptExpression(JsxJavaScriptExpressionTree tree) {
            this.highlightBraces(tree.lCurlyBraceToken(), tree.rCurlyBraceToken());
            super.visitJsxJavaScriptExpression(tree);
        }

        @Override
        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.highlightBraces(tree.openCurlyBrace(), tree.closeCurlyBrace());
            super.visitSwitchStatement(tree);
        }

        private void highlightBraces(SyntaxToken left, SyntaxToken right) {
            Symbol symbol = HighlightSymbolTableBuilder.getHighlightedSymbol(this.builder, (InternalSyntaxToken)left);
            this.builder.newReference(symbol, ((InternalSyntaxToken)right).startIndex());
        }
    }
}

