/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.SymbolicValue;

class TypeOf {
    static final Map<String, Nullability> typeOfEqualNullability = ImmutableMap.builder().put((Object)"undefined", (Object)Nullability.UNDEFINED).put((Object)"function", (Object)Nullability.NOT_NULLY).put((Object)"object", (Object)Nullability.NOT_UNDEFINED).put((Object)"number", (Object)Nullability.NOT_NULLY).put((Object)"string", (Object)Nullability.NOT_NULLY).put((Object)"boolean", (Object)Nullability.NOT_NULLY).put((Object)"symbol", (Object)Nullability.NOT_NULLY).build();
    static final Map<String, Nullability> typeOfNotEqualNullability = ImmutableMap.builder().put((Object)"undefined", (Object)Nullability.NOT_UNDEFINED).put((Object)"object", (Object)Nullability.NOT_NULL).build();

    private TypeOf() {
    }

    @CheckForNull
    static String typeOf(SymbolicValue symbolicValue) {
        if (symbolicValue.equals(SymbolicValue.NULL)) {
            return "object";
        }
        if (symbolicValue.equals(SymbolicValue.UNDEFINED)) {
            return "undefined";
        }
        return null;
    }

    static boolean isValidType(String type) {
        return typeOfEqualNullability.containsKey(type);
    }
}

