/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ArrayLiteralTreeImpl
extends JavaScriptTree
implements ArrayLiteralTree,
TypableTree {
    private SyntaxToken openBracket;
    private final List<ExpressionTree> elements;
    private final List<Tree> elementsAndCommas;
    private SyntaxToken closeBracket;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ArrayLiteralTreeImpl(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.elements = Collections.emptyList();
        this.elementsAndCommas = Collections.emptyList();
        this.closeBracket = closeBracket;
    }

    public ArrayLiteralTreeImpl(List<Tree> elementsAndCommas) {
        this.elementsAndCommas = elementsAndCommas;
        this.elements = ImmutableList.copyOf((Iterable)Iterables.filter(elementsAndCommas, ExpressionTree.class));
    }

    public ArrayLiteralTreeImpl complete(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
        return this;
    }

    @Override
    public SyntaxToken openBracket() {
        return this.openBracket;
    }

    @Override
    public List<ExpressionTree> elements() {
        return this.elements;
    }

    @Override
    public List<Tree> elementsAndCommas() {
        return this.elementsAndCommas;
    }

    @Override
    public SyntaxToken closeBracket() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_LITERAL;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openBracket), this.elementsAndCommas.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeBracket));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitArrayLiteral(this);
    }
}

