/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class LiteralTreeImpl
extends JavaScriptTree
implements LiteralTree,
TypableTree {
    private final Tree.Kind kind;
    private final SyntaxToken token;
    private TypeSet types = TypeSet.emptyTypeSet();

    public LiteralTreeImpl(Tree.Kind kind, SyntaxToken token) {
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.token = token;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public String value() {
        return this.token.text();
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }

    @Override
    public SyntaxToken token() {
        return this.token;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.token);
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitLiteral(this);
    }
}

