/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class TemplateLiteralTreeImpl
extends JavaScriptTree
implements TemplateLiteralTree,
TypableTree {
    private final SyntaxToken openBacktick;
    private final List<Tree> elements;
    private final SyntaxToken closeBacktick;

    public TemplateLiteralTreeImpl(InternalSyntaxToken openBacktick, List<Tree> elements, InternalSyntaxToken closeBacktick) {
        this.openBacktick = openBacktick;
        this.elements = Collections.unmodifiableList(elements);
        this.closeBacktick = closeBacktick;
    }

    @Override
    public SyntaxToken openBacktick() {
        return this.openBacktick;
    }

    @Override
    public List<TemplateCharactersTree> strings() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.elements, TemplateCharactersTree.class));
    }

    @Override
    public List<TemplateExpressionTree> expressions() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.elements, TemplateExpressionTree.class));
    }

    @Override
    public SyntaxToken closeBacktick() {
        return this.closeBacktick;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TEMPLATE_LITERAL;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openBacktick), this.elements.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeBacktick));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitTemplateLiteral(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }

    @Override
    public void add(Type type) {
        throw new UnsupportedOperationException();
    }
}

