/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.javascript.tree.impl.expression.IdentifierTreeImpl;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ScopeVisitor
extends DoubleDispatchVisitor {
    private SymbolModelBuilder symbolModel;
    private Scope currentScope;
    private Map<Tree, Scope> treeScopeMap;
    private List<BlockTree> skippedBlocks;

    public Map<Tree, Scope> getTreeScopeMap() {
        return this.treeScopeMap;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.symbolModel = (SymbolModelBuilder)((Object)this.getContext().getSymbolModel());
        this.currentScope = null;
        this.skippedBlocks = new ArrayList<BlockTree>();
        this.treeScopeMap = new HashMap<Tree, Scope>();
        this.newFunctionScope(tree);
        super.visitScript(tree);
        this.leaveScope();
    }

    @Override
    public void visitBlock(BlockTree tree) {
        if (this.isScopeAlreadyCreated(tree)) {
            super.visitBlock(tree);
        } else {
            this.newBlockScope(tree);
            super.visitBlock(tree);
            this.leaveScope();
        }
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.newBlockScope(tree);
        this.skipBlock(tree.statement());
        super.visitForStatement(tree);
        this.leaveScope();
    }

    @Override
    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.newBlockScope(tree);
        this.skipBlock(tree.statement());
        super.visitForObjectStatement(tree);
        this.leaveScope();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.newBlockScope(tree);
        this.scan(tree.cases());
        this.leaveScope();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.newFunctionScope(tree);
        this.skipBlock(tree.body());
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.newBlockScope(tree);
        this.skipBlock(tree.block());
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.newFunctionScope(tree);
        this.skipBlock(tree.body());
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.newFunctionScope(tree);
        this.skipBlock(tree.body());
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.newFunctionScope(tree);
        this.skipBlock(tree.body());
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.newBlockScope(tree);
        super.visitClass(tree);
        this.leaveScope();
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        ((IdentifierTreeImpl)tree).scope(this.currentScope);
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private void newFunctionScope(Tree tree) {
        this.newScope(tree, false);
    }

    private void newBlockScope(Tree tree) {
        this.newScope(tree, true);
    }

    private void newScope(Tree tree, boolean isBlock) {
        this.currentScope = new Scope(this.currentScope, tree, isBlock);
        this.treeScopeMap.put(tree, this.currentScope);
        this.symbolModel.addScope(this.currentScope);
    }

    private void skipBlock(Tree tree) {
        if (tree.is(Tree.Kind.BLOCK)) {
            this.skippedBlocks.add((BlockTree)tree);
        }
    }

    private boolean isScopeAlreadyCreated(BlockTree tree) {
        return this.skippedBlocks.contains(tree);
    }
}

