/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

public class PreciseIssue
implements Issue {
    private JavaScriptCheck check;
    private Double cost;
    private IssueLocation primaryLocation;
    private List<IssueLocation> secondaryLocations;

    public PreciseIssue(JavaScriptCheck check, IssueLocation primaryLocation) {
        this.check = check;
        this.primaryLocation = primaryLocation;
        this.secondaryLocations = new ArrayList<IssueLocation>();
        this.cost = null;
    }

    @Override
    public JavaScriptCheck check() {
        return this.check;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public PreciseIssue cost(double cost) {
        this.cost = cost;
        return this;
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<IssueLocation> secondaryLocations() {
        return this.secondaryLocations;
    }

    public PreciseIssue secondary(IssueLocation secondaryLocation) {
        this.secondaryLocations.add(secondaryLocation);
        return this;
    }

    public PreciseIssue secondary(Tree tree, String message) {
        this.secondaryLocations.add(new IssueLocation(tree, message));
        return this;
    }

    public PreciseIssue secondary(Tree tree) {
        this.secondaryLocations.add(new IssueLocation(tree, null));
        return this;
    }
}

