/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.javascript;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.samples.javascript.TypeStatistics;

@Rule(key="unknown", name="Unknown type for symbol", description="This rule triggers an issue when a symbol has the \"UNKNOWN\" tag type.", priority=Priority.MAJOR)
public class UnknownCheck
extends BaseTreeVisitor {
    public void visitScript(ScriptTree tree) {
        for (Symbol s : this.getContext().getSymbolModel().getSymbols()) {
            if (s.builtIn()) continue;
            for (Type type : s.types()) {
                if (type.kind() != Type.Kind.UNKNOWN) continue;
                this.getContext().addIssue((JavaScriptCheck)this, UnknownCheck.getSymbolReference(s), String.format("\"%s\"  =>  type %s  -  within %s.", s.name(), type.kind(), s.types().toString()));
                TypeStatistics.increaseUnknown();
            }
        }
    }

    private static Tree getSymbolReference(Symbol s) {
        for (Usage u : s.usages()) {
            if (!u.isDeclaration()) continue;
            return u.identifierTree();
        }
        return ((Usage)s.usages().iterator().next()).identifierTree();
    }
}

