/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S139", priority=Priority.INFO, name="Comments should not be located at the end of lines of code", tags={"convention"})
@SqaleConstantRemediation(value="1min")
public class TrailingCommentCheck
extends PythonCheck
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "S139";
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^#\\s*+[^\\s]++$";
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    @RuleProperty(key="legalTrailingCommentPattern", defaultValue="^#\\s*+[^\\s]++$")
    public String legalCommentPattern = "^#\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public void visitFile(AstNode astNode) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (trivia.getToken().getLine() != this.previousTokenLine || this.pattern.matcher(comment = trivia.getToken().getValue()).matches()) continue;
            this.addIssue(trivia.getToken(), MESSAGE);
        }
        this.previousTokenLine = token.getLine();
    }
}

