/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LineOffsetCounter {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private int currentOriginalLineStartOffset = 0;
    private final List<Integer> originalLineStartOffsets = new ArrayList<Integer>();
    private int[] originalLineStartOffsetsArray;

    LineOffsetCounter(String literalValue) {
        this.originalLineStartOffsets.add(0);
        this.read(literalValue);
    }

    private void handleAll() {
        ++this.currentOriginalLineStartOffset;
    }

    private void newLine() {
        this.originalLineStartOffsets.add(this.currentOriginalLineStartOffset);
    }

    int findLine(int offset) {
        return Math.abs(Arrays.binarySearch(this.startOffset(), offset) + 1);
    }

    int findColumn(int line, int offset) {
        return offset - this.startOffset()[line - 1];
    }

    private int[] startOffset() {
        if (this.originalLineStartOffsetsArray == null) {
            this.originalLineStartOffsetsArray = this.originalLineStartOffsets.stream().mapToInt(i -> i).toArray();
        }
        return this.originalLineStartOffsetsArray;
    }

    private void read(String literalValue) {
        boolean afterCR = false;
        for (char c : literalValue.toCharArray()) {
            if (afterCR) {
                if (c == '\n') {
                    this.handleAll();
                    this.newLine();
                } else {
                    this.newLine();
                    this.handleAll();
                }
                afterCR = c == '\r';
                continue;
            }
            if (c == '\n') {
                this.handleAll();
                this.newLine();
                continue;
            }
            if (c == '\r') {
                afterCR = true;
                this.handleAll();
                continue;
            }
            this.handleAll();
        }
        if (afterCR) {
            this.newLine();
        }
    }
}

