/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Set;
import org.sonar.python.api.PythonTokenType;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class StringLiteralsChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';
    private static final Set<Character> PREFIX_CHARS = ImmutableSet.of((Object)Character.valueOf('R'), (Object)Character.valueOf('F'), (Object)Character.valueOf('U'), (Object)Character.valueOf('B'));
    private final StringBuilder sb = new StringBuilder();
    private int index;
    private char ch;

    public boolean consume(CodeReader code, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        this.index = 0;
        this.readStringPrefix(code);
        if (this.ch != '\'' && this.ch != '\"') {
            return false;
        }
        if (!this.read(code)) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            this.sb.append((char)code.pop());
        }
        output.addToken(new Token[]{Token.builder().setLine(line).setColumn(column).setURI(output.getURI()).setValueAndOriginalValue(this.sb.toString()).setType((TokenType)PythonTokenType.STRING).build()});
        this.sb.setLength(0);
        return true;
    }

    private boolean read(CodeReader code) {
        if (StringLiteralsChannel.isLookingOnLongString(code, this.ch, this.index)) {
            return this.readLongString(code);
        }
        return this.readString(code);
    }

    private boolean readString(CodeReader code) {
        ++this.index;
        while (code.charAt(this.index) != this.ch) {
            if (code.charAt(this.index) == '\uffff') {
                return false;
            }
            if (code.charAt(this.index) == '\\') {
                ++this.index;
            }
            ++this.index;
        }
        ++this.index;
        return true;
    }

    private boolean readLongString(CodeReader code) {
        this.index += 3;
        while (!StringLiteralsChannel.isLookingOnLongString(code, this.ch, this.index)) {
            if (code.charAt(this.index) == '\uffff') {
                return false;
            }
            if (code.charAt(this.index) == '\\') {
                ++this.index;
            }
            ++this.index;
        }
        this.index += 3;
        return true;
    }

    private void readStringPrefix(CodeReader code) {
        this.ch = Character.toUpperCase(code.charAt(this.index));
        if (PREFIX_CHARS.contains(Character.valueOf(this.ch))) {
            ++this.index;
            this.ch = Character.toUpperCase(code.charAt(this.index));
        }
        if (PREFIX_CHARS.contains(Character.valueOf(this.ch))) {
            ++this.index;
            this.ch = code.charAt(this.index);
        }
    }

    private static boolean isLookingOnLongString(CodeReader code, char ch, int index) {
        return code.charAt(index) == ch && code.charAt(index + 1) == ch && code.charAt(index + 2) == ch;
    }
}

