/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Lexer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.api.source.Highlightable;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.lexer.EcmaScriptLexer;

public class JavaScriptHighlighter {
    private Lexer lexer;
    private Charset charset;

    public JavaScriptHighlighter(EcmaScriptConfiguration conf) {
        this.lexer = EcmaScriptLexer.create(conf);
        this.charset = conf.getCharset();
    }

    public void highlight(Highlightable highlightable, File file) {
        SourceFileOffsets offsets = new SourceFileOffsets(file, this.charset);
        List tokens = this.lexer.lex(file);
        this.doHighlight(highlightable, tokens, offsets);
    }

    public void highlight(Highlightable highlightable, String string) {
        SourceFileOffsets offsets = new SourceFileOffsets(string);
        List tokens = this.lexer.lex(string);
        this.doHighlight(highlightable, tokens, offsets);
    }

    private void doHighlight(Highlightable highlightable, List<Token> tokens, SourceFileOffsets offsets) {
        Highlightable.HighlightingBuilder highlighting = highlightable.newHighlighting();
        this.highlightStringsAndKeywords(highlighting, tokens, offsets);
        JavaScriptHighlighter.highlightComments(highlighting, tokens, offsets);
        highlighting.done();
    }

    private static void highlightComments(Highlightable.HighlightingBuilder highlighting, List<Token> tokens, SourceFileOffsets offsets) {
        for (Token token : tokens) {
            if (token.getTrivia().isEmpty()) continue;
            for (Trivia trivia : token.getTrivia()) {
                String code = trivia.getToken().getValue().startsWith("/**") ? "j" : "cd";
                JavaScriptHighlighter.highlight(highlighting, offsets.startOffset(trivia.getToken()), offsets.endOffset(trivia.getToken()), code);
            }
        }
    }

    private void highlightStringsAndKeywords(Highlightable.HighlightingBuilder highlighting, List<Token> tokens, SourceFileOffsets offsets) {
        for (Token token : tokens) {
            if (GenericTokenType.LITERAL.equals((Object)token.getType())) {
                JavaScriptHighlighter.highlight(highlighting, offsets.startOffset(token), offsets.endOffset(token), "s");
            }
            if (!this.isKeyword(token.getType())) continue;
            JavaScriptHighlighter.highlight(highlighting, offsets.startOffset(token), offsets.endOffset(token), "k");
        }
    }

    private static void highlight(Highlightable.HighlightingBuilder highlighting, int startOffset, int endOffset, String code) {
        if (endOffset > startOffset) {
            highlighting.highlight(startOffset, endOffset, code);
        }
    }

    public boolean isKeyword(TokenType type) {
        for (EcmaScriptKeyword keywordType : EcmaScriptKeyword.values()) {
            if (!((Object)((Object)keywordType)).equals(type)) continue;
            return true;
        }
        return false;
    }
}

