/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.declaration;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.SeparatedList;
import org.sonar.javascript.model.internal.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ObjectBindingPatternTreeImpl
extends JavaScriptTree
implements ObjectBindingPatternTree {
    private SyntaxToken openCurlyBrace;
    private SeparatedList<Tree> bindingElements;
    private SyntaxToken closeCurlyBrace;

    public ObjectBindingPatternTreeImpl(SeparatedList<Tree> bindingElements) {
        super(Tree.Kind.OBJECT_BINDING_PATTERN);
        this.bindingElements = bindingElements;
        for (AstNode child : bindingElements.getChildren()) {
            this.addChild(child);
        }
        bindingElements.clearChildren();
    }

    public ObjectBindingPatternTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.OBJECT_BINDING_PATTERN);
        this.openCurlyBrace = openCurlyBrace;
        this.bindingElements = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.closeCurlyBrace = closeCurlyBrace;
        this.addChildren(openCurlyBrace, closeCurlyBrace);
    }

    public ObjectBindingPatternTreeImpl complete(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.prependChildren(openCurlyBrace);
        this.addChild(closeCurlyBrace);
        return this;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<Tree> elements() {
        return this.bindingElements;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_BINDING_PATTERN;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.bindingElements.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitObjectBindingPattern(this);
    }

    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        for (Tree element : this.bindingElements) {
            if (element.is(Tree.Kind.BINDING_PROPERTY)) {
                bindingIdentifiers.addAll(this.identifierFromBindingElement(((BindingPropertyTree)element).value()));
                continue;
            }
            if (element.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                bindingIdentifiers.addAll(this.identifierFromBindingElement(((InitializedBindingElementTree)element).left()));
                continue;
            }
            bindingIdentifiers.addAll(this.identifierFromBindingElement((BindingElementTree)element));
        }
        return bindingIdentifiers;
    }

    private List<IdentifierTree> identifierFromBindingElement(BindingElementTree bindingEement) {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        if (bindingEement.is(Tree.Kind.BINDING_IDENTIFIER)) {
            bindingIdentifiers.add((IdentifierTree)bindingEement);
        } else if (bindingEement.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            bindingIdentifiers.addAll(((ObjectBindingPatternTreeImpl)bindingEement).bindingIdentifiers());
        } else {
            bindingIdentifiers.addAll(((ArrayBindingPatternTreeImpl)bindingEement).bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

