/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.resolve.type.FunctionType;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.internal.expression.IdentifierTreeImpl;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.internal.statement.BlockTreeImpl;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class FunctionExpressionTreeImpl
extends JavaScriptTree
implements FunctionExpressionTree {
    private final SyntaxToken functionKeyword;
    @Nullable
    private final SyntaxToken star;
    @Nullable
    private final IdentifierTree name;
    private final ParameterListTree parameters;
    private final BlockTreeImpl body;
    private final Tree.Kind kind;
    private Type functionType;

    public FunctionExpressionTreeImpl(Tree.Kind kind, InternalSyntaxToken functionKeyword, InternalSyntaxToken star, IdentifierTreeImpl name, ParameterListTreeImpl parameters, BlockTreeImpl body, List<AstNode> children) {
        super(kind);
        this.functionKeyword = functionKeyword;
        this.star = star;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        this.kind = kind;
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.functionType = FunctionType.create(this);
    }

    public FunctionExpressionTreeImpl(Tree.Kind kind, InternalSyntaxToken functionKeyword, InternalSyntaxToken star, ParameterListTreeImpl parameters, BlockTreeImpl body, ImmutableList<AstNode> children) {
        super(kind);
        this.functionKeyword = functionKeyword;
        this.star = star;
        this.name = null;
        this.parameters = parameters;
        this.body = body;
        this.kind = kind;
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.functionType = FunctionType.create(this);
    }

    public FunctionExpressionTreeImpl(Tree.Kind kind, InternalSyntaxToken functionKeyword, IdentifierTreeImpl name, ParameterListTreeImpl parameters, BlockTreeImpl body, ImmutableList<AstNode> children) {
        super(kind);
        this.functionKeyword = functionKeyword;
        this.star = null;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        this.kind = kind;
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.functionType = FunctionType.create(this);
    }

    public FunctionExpressionTreeImpl(Tree.Kind kind, InternalSyntaxToken functionKeyword, ParameterListTreeImpl parameters, BlockTreeImpl body, ImmutableList<AstNode> children) {
        super(kind);
        this.functionKeyword = functionKeyword;
        this.star = null;
        this.name = null;
        this.parameters = parameters;
        this.body = body;
        this.kind = kind;
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.functionType = FunctionType.create(this);
    }

    @Override
    public SyntaxToken functionKeyword() {
        return this.functionKeyword;
    }

    @Override
    @Nullable
    public SyntaxToken star() {
        return this.star;
    }

    @Override
    @Nullable
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    public ParameterListTree parameters() {
        return this.parameters;
    }

    @Override
    public AstNodeType getKind() {
        return this.kind;
    }

    @Override
    public BlockTreeImpl body() {
        return this.body;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.name, this.parameters, this.body});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFunctionExpression(this);
    }

    @Override
    public TypeSet types() {
        TypeSet set = TypeSet.emptyTypeSet();
        set.add(this.functionType);
        return set;
    }
}

