/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class LiteralTreeImpl
extends JavaScriptTree
implements LiteralTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken token;
    private TypeSet types = TypeSet.emptyTypeSet();

    public LiteralTreeImpl(Tree.Kind kind, InternalSyntaxToken token) {
        super(kind, token.getToken());
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.token = token;
        this.addChild(token);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public String value() {
        return this.token.text();
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.token);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLiteral(this);
    }
}

