/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ParenthesisedExpressionTreeImpl
extends JavaScriptTree
implements ParenthesisedExpressionTree {
    private final InternalSyntaxToken openParenthesis;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeParenthesis;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ParenthesisedExpressionTreeImpl(InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis) {
        super(Tree.Kind.PARENTHESISED_EXPRESSION);
        this.openParenthesis = openParenthesis;
        this.expression = expression;
        this.closeParenthesis = closeParenthesis;
        this.addChildren(openParenthesis, (AstNode)expression, closeParenthesis);
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARENTHESISED_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openParenthesis), (Iterator)Iterators.singletonIterator((Object)this.expression), (Iterator)Iterators.singletonIterator((Object)this.closeParenthesis));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParenthesisedExpression(this);
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public void addTypes(TypeSet types) {
        this.types.addAll(types);
    }
}

