/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.lexical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class InternalSyntaxToken
extends JavaScriptTree
implements SyntaxToken {
    private final Token token;
    private List<SyntaxTrivia> trivias;

    public InternalSyntaxToken(AstNodeType astNodeType, Token token, int fromIndex, int toIndex) {
        super(astNodeType, token);
        this.token = token;
        this.trivias = this.createTrivias(token);
        this.setFromIndex(fromIndex);
        this.setToIndex(toIndex);
    }

    private InternalSyntaxToken(AstNode astNode) {
        super(astNode);
        this.token = astNode.getToken();
        this.trivias = this.createTrivias(this.token);
    }

    public InternalSyntaxToken(Token token) {
        super((AstNode)null);
        this.token = token;
        this.trivias = this.createTrivias(token);
    }

    @Override
    public String text() {
        return this.token.getValue();
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    private List<SyntaxTrivia> createTrivias(Token token) {
        ArrayList result = Lists.newArrayList();
        for (Trivia trivia : token.getTrivia()) {
            result.add(InternalSyntaxTrivia.create(trivia.getToken().getValue(), trivia.getToken().getLine()));
        }
        return result;
    }

    @Override
    public int getLine() {
        return this.token.getLine();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TOKEN;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isEOF() {
        return this.token.getType() == GenericTokenType.EOF;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        throw new UnsupportedOperationException();
    }

    public static InternalSyntaxToken create(AstNode astNode) {
        Preconditions.checkArgument((boolean)astNode.hasToken(), (Object)"has no token");
        Preconditions.checkArgument((astNode.getToken() == astNode.getLastToken() ? 1 : 0) != 0, (Object)"has several tokens");
        return new InternalSyntaxToken(astNode.getType(), astNode.getToken(), astNode.getFromIndex(), astNode.getToIndex());
    }

    public static InternalSyntaxToken createLegacy(AstNode astNode) {
        return new InternalSyntaxToken(astNode);
    }

    @Override
    public void accept(TreeVisitor visitor) {
    }
}

