/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ElseClauseTreeImpl
extends JavaScriptTree
implements ElseClauseTree {
    private SyntaxToken elseKeyword;
    private final StatementTree statement;

    public ElseClauseTreeImpl(InternalSyntaxToken elseKeyword, StatementTree statement) {
        super(Tree.Kind.ELSE_CLAUSE);
        this.elseKeyword = elseKeyword;
        this.statement = statement;
        this.addChildren(elseKeyword, (AstNode)statement);
    }

    @Override
    public SyntaxToken elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @Nullable
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.ELSE_CLAUSE;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.statement);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitElseClause(this);
    }
}

