/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ReturnStatementTreeImpl
extends JavaScriptTree
implements ReturnStatementTree {
    private SyntaxToken returnKeyword;
    private ExpressionTree expression;

    public ReturnStatementTreeImpl(AstNode eos) {
        super(Tree.Kind.RETURN_STATEMENT);
        this.addChild(eos);
    }

    public ReturnStatementTreeImpl(ExpressionTree expression, AstNode eos) {
        super(Tree.Kind.RETURN_STATEMENT);
        this.expression = expression;
        this.addChild((AstNode)expression);
        this.addChild(eos);
    }

    public ReturnStatementTreeImpl complete(InternalSyntaxToken returnKeyword) {
        Preconditions.checkState((this.returnKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.returnKeyword = returnKeyword;
        this.prependChildren(returnKeyword);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STATEMENT;
    }

    @Override
    public SyntaxToken returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    @Nullable
    public Tree endOfStatement() {
        throw new UnsupportedOperationException("Not supported yet in the strongly typed AST.");
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }
}

