/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.type.SqlMetaType;

public class SqlCrudEngine
extends SqlEngine {
    public SqlCrudEngine(String name, String statement) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(statement, SqlMetaType.META_TO_TYPE_MAP), null, null, null, SqlMetaType.CLASS_TO_TYPE_MAP);
    }

    public SqlCrudEngine(String name, String statement, SqlMonitor monitor, Map<String, Object> features, Map<Class<?>, SqlMetaType> classToTypeMap) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(statement, SqlMetaType.META_TO_TYPE_MAP), null, monitor, features, classToTypeMap);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement) {
        super(name, statement, null, null, null, SqlMetaType.CLASS_TO_TYPE_MAP);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMonitor monitor, Map<String, Object> features, Map<Class<?>, SqlMetaType> classToTypeMap) {
        super(name, statement, null, monitor, features, classToTypeMap);
    }

    public int insert(Session session, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.insert(session, dynamicInputValues, null, 0);
    }

    public int insert(Session session, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.insert(session, dynamicInputValues, staticInputValues, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(final Session session, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> insert, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.statement.process(SqlMetaStatement.Type.CREATE, dynamicInputValues, staticInputValues, null, SqlCrudEngine.this.features, SqlCrudEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    Integer count = query.executeUpdate();
                    processResult.postProcess();
                    return count;
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< insert, result=" + count);
            }
        }
    }

    public <E> E get(Session session, Class<E> resultClass, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, null, 0);
    }

    public <E> E get(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, staticInputValues, 0);
    }

    public <E> E get(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws HibernateException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, staticInputValues, 0, moreResultClasses);
    }

    public <E> E get(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws HibernateException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, staticInputValues, maxTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E get(final Session session, final Class<E> resultClass, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout, final Map<String, Class<?>> moreResultClasses) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> get, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout + ", moreResultClasses=" + moreResultClasses);
        }
        E result = null;
        try {
            E e = result = (E)this.monitor.run(new SqlMonitor.Runner(){

                public E run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.statement.process(SqlMetaStatement.Type.RETRIEVE, dynamicInputValues, staticInputValues, null, SqlCrudEngine.this.features, SqlCrudEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    SqlMappingResult mappingResult = SqlMappingRule.merge(SqlCrudEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, moreResultClasses, query);
                    Object resultRow = query.uniqueResult();
                    if (resultRow != null) {
                        Object[] objectArray;
                        if (resultRow instanceof Object[]) {
                            objectArray = (Object[])resultRow;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = resultRow;
                        }
                        Object[] resultValue = objectArray;
                        HashMap<String, Object> instances = new HashMap<String, Object>();
                        Object resultInstance = BeanUtils.getInstance(resultClass);
                        if (resultInstance == null) {
                            throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
                        }
                        mappingResult.setQueryResultData(resultInstance, resultValue, instances, null, moreResultClasses);
                        return resultInstance;
                    }
                    return null;
                }
            }, resultClass);
            return e;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< get, result=" + result);
            }
        }
    }

    public int update(Session session, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.update(session, dynamicInputValues, null, 0);
    }

    public int update(Session session, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.update(session, dynamicInputValues, staticInputValues, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(final Session session, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> update, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.statement.process(SqlMetaStatement.Type.UPDATE, dynamicInputValues, staticInputValues, null, SqlCrudEngine.this.features, SqlCrudEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    return query.executeUpdate();
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< update, result=" + count);
            }
        }
    }

    public int delete(Session session, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.delete(session, dynamicInputValues, null, 0);
    }

    public int delete(Session session, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.delete(session, dynamicInputValues, staticInputValues, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(final Session session, final Object dynamicInputValues, final Object staticInputValues, final int maxTimeout) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> delete, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", maxTimeout=" + maxTimeout);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.statement.process(SqlMetaStatement.Type.DELETE, dynamicInputValues, staticInputValues, null, SqlCrudEngine.this.features, SqlCrudEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    return query.executeUpdate();
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< delete, result=" + count);
            }
        }
    }

    public String getInsertSql(Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CREATE);
    }

    public String getGetSql(Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.RETRIEVE);
    }

    public String getUpdateSql(Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.UPDATE);
    }

    public String getDeleteSql(Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final Object staticInputValues, final SqlMetaStatement.Type statementType) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues);
        }
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.statement.process(statementType, dynamicInputValues, staticInputValues, null, SqlCrudEngine.this.features, SqlCrudEngine.this.classToTypeMap);
                    return processResult.getSql().toString();
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

