/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.impl.type.SqlMetaType;

public class SqlQueryEngine
extends SqlEngine {
    public static final SqlOrder NO_ORDER = SqlOrder.getOrder();
    public static final SqlOrder ASC_ORDER = SqlOrder.getAscOrder(1);
    public static final SqlOrder DESC_ORDER = SqlOrder.getDescOrder(1);

    public SqlQueryEngine(String name, String statement, String mapping) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(statement, SqlMetaType.META_TO_TYPE_MAP), mapping != null ? SqlMappingRule.getInstance(mapping, SqlMetaType.META_TO_TYPE_MAP) : null, null, null, SqlMetaType.CLASS_TO_TYPE_MAP);
    }

    public SqlQueryEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, Map<Class<?>, SqlMetaType> classToTypeMap) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(statement, SqlMetaType.META_TO_TYPE_MAP), mapping != null ? SqlMappingRule.getInstance(mapping, SqlMetaType.META_TO_TYPE_MAP) : null, monitor, features, classToTypeMap);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping) {
        super(name, statement, mapping, null, null, SqlMetaType.CLASS_TO_TYPE_MAP);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, Map<Class<?>, SqlMetaType> classToTypeMap) {
        super(name, statement, mapping, monitor, features, classToTypeMap);
    }

    public <E> List<E> query(Session session, Class<E> resultClass) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, null, null, NO_ORDER, 0, 0, 0);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, null, NO_ORDER, 0, 0, 0);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, SqlOrder order) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, null, order, 0, 0, 0);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, NO_ORDER, 0, 0, 0);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, NO_ORDER, 0, 0, 0, moreResultClasses);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, order, 0, 0, 0);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Map<String, Class<?>> moreResultClasses) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, order, 0, 0, 0, moreResultClasses);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, int firstResult, int maxResults) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, null, NO_ORDER, 0, maxResults, firstResult);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int firstResult, int maxResults) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, NO_ORDER, 0, maxResults, firstResult);
    }

    public <E> List<E> query(Session session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, int maxTimeout, int maxResults, int firstResult) throws HibernateException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, staticInputValues, order, maxTimeout, maxResults, firstResult, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> query(final Session session, final Class<E> resultClass, final Object dynamicInputValues, final Object staticInputValues, final SqlOrder order, final int maxTimeout, final int maxResults, final int firstResult, final Map<String, Class<?>> moreResultClasses) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> query, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", order=" + order + ", maxTimeout=" + maxTimeout + ", maxResults=" + maxResults + ", firstResult=" + firstResult + ", moreResultClasses=" + moreResultClasses);
        }
        List<E> result = null;
        try {
            List<E> list = result = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.statement.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, staticInputValues, order.getOrders(), SqlQueryEngine.this.features, SqlQueryEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    SqlMappingResult mappingResult = SqlMappingRule.merge(SqlQueryEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, moreResultClasses, query);
                    if (firstResult > 0) {
                        query.setFirstResult(firstResult);
                        query.setMaxResults(maxResults);
                    } else if (maxResults > 0) {
                        query.setMaxResults(maxResults + 1);
                    }
                    List list = query.list();
                    ArrayList<Object> result = new ArrayList<Object>();
                    Object resultInstance = null;
                    Object previousInstance = null;
                    Object[] resultValue = null;
                    Object[] previousResultValue = null;
                    boolean[] changedIdentities = null;
                    HashMap<String, Object> instances = new HashMap<String, Object>();
                    for (Object resultRow : list) {
                        Object[] objectArray;
                        if (resultRow instanceof Object[]) {
                            objectArray = (Object[])resultRow;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = resultRow;
                        }
                        resultValue = objectArray;
                        changedIdentities = SqlUtils.changedIdentities(resultValue, previousResultValue);
                        boolean changedIdentity = SqlUtils.changedIdentity(changedIdentities, mappingResult.getMainIdentityIndex());
                        Object e = resultInstance = changedIdentity ? (Object)BeanUtils.getInstance(resultClass) : previousInstance;
                        if (resultInstance == null) {
                            throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
                        }
                        mappingResult.setQueryResultData(resultInstance, resultValue, instances, changedIdentities, moreResultClasses);
                        if (changedIdentity) {
                            result.add(resultInstance);
                        }
                        previousInstance = resultInstance;
                        previousResultValue = resultValue;
                    }
                    return result;
                }
            }, resultClass);
            return list;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< query, result=" + result);
            }
        }
    }

    public int queryCount(Session session) throws HibernateException, SqlRuntimeException {
        return this.queryCount(session, new Object(), null, NO_ORDER, 0);
    }

    public int queryCount(Session session, Object dynamicInputValues) throws HibernateException, SqlRuntimeException {
        return this.queryCount(session, dynamicInputValues, null, NO_ORDER, 0);
    }

    public int queryCount(Session session, Object dynamicInputValues, Object staticInputValues) throws HibernateException, SqlRuntimeException {
        return this.queryCount(session, dynamicInputValues, staticInputValues, NO_ORDER, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(final Session session, final Object dynamicInputValues, final Object staticInputValues, final SqlOrder order, final int maxTimeout) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> queryCount, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", order=" + order + ", maxTimeout=" + maxTimeout);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.statement.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, staticInputValues, order.getOrders(), SqlQueryEngine.this.features, SqlQueryEngine.this.classToTypeMap);
                    SQLQuery query = session.createSQLQuery(processResult.getSql().toString());
                    if (maxTimeout > 0) {
                        query.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, query);
                    SQLQuery queryCount = session.createSQLQuery(SqlQueryEngine.this.countSql(processResult));
                    queryCount.addScalar("vysledek", (Type)Hibernate.INTEGER);
                    if (maxTimeout > 0) {
                        queryCount.setTimeout(maxTimeout);
                    }
                    processResult.setQueryParams(session, queryCount);
                    return (Integer)queryCount.uniqueResult();
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< queryCount, count=" + count);
            }
        }
    }

    private String countSql(SqlProcessResult processResult) {
        String s = processResult.getSql().toString().toUpperCase();
        int start = s.indexOf("ID");
        int end = s.indexOf("FROM");
        StringBuilder sb = processResult.getSql();
        if (start < 0 || end < 0 || start > end) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        String s1 = sb.substring(0, start + 2);
        String s2 = sb.substring(end);
        start = s1.toUpperCase().indexOf("SELECT");
        if (start < 0) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        return s1.substring(0, start) + "select count(" + s1.substring(start + 6) + ") as vysledek " + s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final Object staticInputValues, final SqlOrder order) throws HibernateException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", staticInputValues=" + staticInputValues + ", order=" + order);
        }
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.statement.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, staticInputValues, order.getOrders(), SqlQueryEngine.this.features, SqlQueryEngine.this.classToTypeMap);
                    return processResult.getSql().toString();
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

