// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/sqlproc/engine/impl/SqlProcessor.g 2011-09-24 07:02:20
 
package org.sqlproc.engine.impl;

import java.util.Map;
import java.util.Set;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class SqlProcessorParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "WS", "IDENT", "LPAREN", "STATEMENT", "COMMA", "RPAREN", "EQUALS", "SEMICOLON", "MAPPING", "OPTION", "COLON", "STRING", "AT", "PERCENT", "LBRACE", "RBRACE", "QUESTI", "BAND", "BOR", "HASH", "NUMBER", "AND", "OR", "NOT", "IDENT_DOT", "CARET", "PLUS", "MINUS", "LESS_THAN", "MORE_THAN", "DOT", "DIGIT", "ML_COMMENT", "SL_COMMENT", "ESC_COLON", "ESC_SEMICOLON", "ESC_STRING", "ESC_LBRACE", "ESC_RBRACE", "ESC_BOR", "ESC_HASH", "ESC_AT", "ESC_PERCENT", "ESC_DOT", "ESC_CHAR", "REST"
    };
    public static final int EOF=-1;
    public static final int WS=4;
    public static final int IDENT=5;
    public static final int LPAREN=6;
    public static final int STATEMENT=7;
    public static final int COMMA=8;
    public static final int RPAREN=9;
    public static final int EQUALS=10;
    public static final int SEMICOLON=11;
    public static final int MAPPING=12;
    public static final int OPTION=13;
    public static final int COLON=14;
    public static final int STRING=15;
    public static final int AT=16;
    public static final int PERCENT=17;
    public static final int LBRACE=18;
    public static final int RBRACE=19;
    public static final int QUESTI=20;
    public static final int BAND=21;
    public static final int BOR=22;
    public static final int HASH=23;
    public static final int NUMBER=24;
    public static final int AND=25;
    public static final int OR=26;
    public static final int NOT=27;
    public static final int IDENT_DOT=28;
    public static final int CARET=29;
    public static final int PLUS=30;
    public static final int MINUS=31;
    public static final int LESS_THAN=32;
    public static final int MORE_THAN=33;
    public static final int DOT=34;
    public static final int DIGIT=35;
    public static final int ML_COMMENT=36;
    public static final int SL_COMMENT=37;
    public static final int ESC_COLON=38;
    public static final int ESC_SEMICOLON=39;
    public static final int ESC_STRING=40;
    public static final int ESC_LBRACE=41;
    public static final int ESC_RBRACE=42;
    public static final int ESC_BOR=43;
    public static final int ESC_HASH=44;
    public static final int ESC_AT=45;
    public static final int ESC_PERCENT=46;
    public static final int ESC_DOT=47;
    public static final int ESC_CHAR=48;
    public static final int REST=49;

    // delegates
    // delegators


        public SqlProcessorParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public SqlProcessorParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return SqlProcessorParser.tokenNames; }
    public String getGrammarFileName() { return "org/sqlproc/engine/impl/SqlProcessor.g"; }


      private Token getLastToken() {
        return input.LT(-1);
      }

      private Stack artifactName = new Stack();
      private Stack partialErrors = new Stack();
      private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
      
      public List<ErrorMsg> getErrors() {
        return errors;
      }

      @Override
      public void reportError(RecognitionException e) {
        String msg = super.getErrorMessage(e,tokenNames);
        if ( artifactName.size()>0 ) {
          String name = (String)artifactName.peek();
          partialErrors.push(ParserUtils.create(name,msg,e,tokenNames));
        }
        else {
          errors.add(ParserUtils.create(null,msg,e,tokenNames));
        }
      }
      
      String getText(Token token) {
        if (token == null)
          return null;
        return token.getText();
      }
      
      void add(StringBuilder text) {
        int type = getLastToken().getType();
        if (type == ESC_CHAR) {
          text.append(getLastToken().getText().substring(1));
        } 
        else if (type == WS) {
          String s = getLastToken().getText();
          for (int i = 0, l = s.length(); i < l; i++) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r')
              continue;
            text.append(c);
          }
        } 
        else {
          text.append(getLastToken().getText());
        }
      }
      
      void addText(Object target, StringBuilder text) {
        ParserUtils.addText(target, text);
      }
      
      void addColumn(Object target, SqlMappingItem col, StringBuilder text) {
        ParserUtils.addColumn(target, col, text);
      }
      
      SqlMappingItem newColumn(Token col) {
        return ParserUtils.newColumn(col.getText());
      }
      
      void addColumnAttr(SqlMappingItem item, Token col) {
        ParserUtils.addColumnAttr(item, col.getText());
      }
      
      void addDatabaseColumn(Object target, SqlDatabaseColumn dbcol, StringBuilder text) {
        ParserUtils.addDatabaseColumn(target, dbcol, text);
      }
      
      SqlDatabaseColumn newDatabaseColumn(Token col) {
        return ParserUtils.newDatabaseColumn(col.getText());
      }
      
      void addDatabaseTable(Object target, SqlDatabaseTable dbtab, StringBuilder text) {
        ParserUtils.addDatabaseTable(target, dbtab, text);
      }
      
      SqlDatabaseTable newDatabaseTable(Token col) {
        return ParserUtils.newDatabaseTable(col.getText());
      }
      
      void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
        ParserUtils.addIdent(target, ident, text);
      }
      
      SqlMetaIdent newIdent(Token ident, Token modeIdent, Token caseIdent) {
        return ParserUtils.newIdent(ident.getText(), getText(modeIdent), getText(caseIdent));
      }
      
      void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
        ParserUtils.addConstant(target, cnst, text);
      }
      
      SqlMetaConst newConstant(Token cnst, Token caseConversion) {
        return ParserUtils.newConstant(cnst.getText(), getText(caseConversion));
      }
      
      void addOperator(SqlMetaLogExpr expr, boolean isAnd) {
        if (isAnd)
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.AND));
        else
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.OR));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMappingItem item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaIdent item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaConst item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }
      
      boolean doSkip(Set<String> onlyStatements, String name) {
        if (onlyStatements == null || onlyStatements.isEmpty())
          return false;
        return !onlyStatements.contains(name);
      }
      
      List<ErrorMsg> getPartialErrors() {
        if (partialErrors.size()==0)
          return null;
        List<ErrorMsg> errorsList = new ArrayList<ErrorMsg>();
        while ( partialErrors.size()>0 ) {
          ErrorMsg errorMsg = (ErrorMsg) partialErrors.pop(); 
          errorsList.add(errorMsg);
        }
        return errorsList;
      }
      
      boolean add(SqlProcessor processor, String type, String name, SqlMetaStatement statement, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addMetaStatement(type, name, statement, errorsList, activeFilters, filters);
        return errorsList == null;
      }
      
      boolean add(SqlProcessor processor, String type, String name, SqlMappingRule mapping, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addMappingRule(type, name, mapping, errorsList, activeFilters, filters);
        return errorsList == null;
      }
      
      boolean add(SqlProcessor processor, String type, String name, String feature, List<String> activeFilters, String... filters) {
        List<ErrorMsg> errorsList = getPartialErrors();
        processor.addFeature(type, name, feature, errorsList, activeFilters, filters);
        return errorsList == null;
      }



    // $ANTLR start "parse"
    // org/sqlproc/engine/impl/SqlProcessor.g:187:1: parse[SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters] returns [SqlProcessor processor] : ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF ;
    public final SqlProcessor parse(SqlTypeFactory _typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String[] filters) throws RecognitionException {
        SqlProcessor processor = null;

        Token name=null;
        Token type=null;
        Token filter=null;
        SqlMetaStatement metaStatement = null;

        SqlMappingRule mappingRule = null;

        StringBuilder text = null;


        processor = new SqlProcessor(defaultFeatures, onlyStatements); boolean skip; List<String> activeFilters;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:189:9: ( ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF )
            // org/sqlproc/engine/impl/SqlProcessor.g:190:9: ( WS )* ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+ EOF
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:190:9: ( WS )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:190:9: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_parse73); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:190:13: ( (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* ) | (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* ) )+
            int cnt8=0;
            loop8:
            do {
                int alt8=4;
                switch ( input.LA(1) ) {
                case IDENT:
                    {
                    switch ( input.LA(2) ) {
                    case LPAREN:
                        {
                        switch ( input.LA(3) ) {
                        case OPTION:
                            {
                            alt8=3;
                            }
                            break;
                        case STATEMENT:
                            {
                            alt8=1;
                            }
                            break;
                        case MAPPING:
                            {
                            alt8=2;
                            }
                            break;

                        }

                        }
                        break;

                    }

                    }
                    break;

                }

                switch (alt8) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:191:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:191:10: (name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:191:11: name= IDENT LPAREN type= STATEMENT ( COMMA filter= IDENT )* RPAREN EQUALS metaStatement= meta[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse90); 
            	    skip=doSkip(onlyStatements,(name!=null?name.getText():null));
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse94); 
            	    type=(Token)match(input,STATEMENT,FOLLOW_STATEMENT_in_parse98); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:191:129: ( COMMA filter= IDENT )*
            	    loop2:
            	    do {
            	        int alt2=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt2=1;
            	            }
            	            break;

            	        }

            	        switch (alt2) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:191:130: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse103); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse107); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop2;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse113); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse115); 
            	    pushFollow(FOLLOW_meta_in_parse131);
            	    metaStatement=meta((name!=null?name.getText():null), _typeFactory, skip);

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), metaStatement, activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse136); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:192:154: ( WS )*
            	    loop3:
            	    do {
            	        int alt3=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt3=1;
            	            }
            	            break;

            	        }

            	        switch (alt3) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:192:154: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse138); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop3;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;
            	case 2 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:193:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:193:12: (name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:193:13: name= IDENT LPAREN type= MAPPING ( COMMA filter= IDENT )* RPAREN EQUALS mappingRule= mapping[$name.text, _typeFactory, skip] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse156); 
            	    skip=doSkip(onlyStatements,(name!=null?name.getText():null));
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse160); 
            	    type=(Token)match(input,MAPPING,FOLLOW_MAPPING_in_parse164); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:193:129: ( COMMA filter= IDENT )*
            	    loop4:
            	    do {
            	        int alt4=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt4=1;
            	            }
            	            break;

            	        }

            	        switch (alt4) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:193:130: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse169); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse173); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop4;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse179); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse181); 
            	    pushFollow(FOLLOW_mapping_in_parse197);
            	    mappingRule=mapping((name!=null?name.getText():null), _typeFactory, skip);

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), mappingRule, activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse202); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:194:153: ( WS )*
            	    loop5:
            	    do {
            	        int alt5=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt5=1;
            	            }
            	            break;

            	        }

            	        switch (alt5) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:194:153: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse204); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop5;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;
            	case 3 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:195:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:195:12: (name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )* )
            	    // org/sqlproc/engine/impl/SqlProcessor.g:195:13: name= IDENT LPAREN type= OPTION ( COMMA filter= IDENT )* RPAREN EQUALS text= option[$name.text] SEMICOLON ( WS )*
            	    {
            	    name=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse222); 
            	    match(input,LPAREN,FOLLOW_LPAREN_in_parse224); 
            	    type=(Token)match(input,OPTION,FOLLOW_OPTION_in_parse228); 
            	    activeFilters = new ArrayList<String>();
            	    // org/sqlproc/engine/impl/SqlProcessor.g:195:86: ( COMMA filter= IDENT )*
            	    loop6:
            	    do {
            	        int alt6=2;
            	        switch ( input.LA(1) ) {
            	        case COMMA:
            	            {
            	            alt6=1;
            	            }
            	            break;

            	        }

            	        switch (alt6) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:195:87: COMMA filter= IDENT
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_parse233); 
            	    	    filter=(Token)match(input,IDENT,FOLLOW_IDENT_in_parse237); 
            	    	    activeFilters.add((filter!=null?filter.getText():null));

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop6;
            	        }
            	    } while (true);

            	    match(input,RPAREN,FOLLOW_RPAREN_in_parse243); 
            	    match(input,EQUALS,FOLLOW_EQUALS_in_parse245); 
            	    pushFollow(FOLLOW_option_in_parse261);
            	    text=option((name!=null?name.getText():null));

            	    state._fsp--;

            	    add(processor, (type!=null?type.getText():null), (name!=null?name.getText():null), text.toString(), activeFilters, filters);
            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_parse266); 
            	    // org/sqlproc/engine/impl/SqlProcessor.g:196:129: ( WS )*
            	    loop7:
            	    do {
            	        int alt7=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt7=1;
            	            }
            	            break;

            	        }

            	        switch (alt7) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:196:129: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_parse268); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop7;
            	        }
            	    } while (true);


            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt8 >= 1 ) break loop8;
                        EarlyExitException eee =
                            new EarlyExitException(8, input);
                        throw eee;
                }
                cnt8++;
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_parse283); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return processor;
    }
    // $ANTLR end "parse"

    protected static class meta_scope {
        StringBuilder text;
        boolean hasOutputMapping;
        SqlTypeFactory typeFactory;
        boolean skip;
    }
    protected Stack meta_stack = new Stack();


    // $ANTLR start "meta"
    // org/sqlproc/engine/impl/SqlProcessor.g:200:1: meta[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMetaStatement metaStatement] : sql[metaStatement] ( EOF )? ;
    public final SqlMetaStatement meta(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
        meta_stack.push(new meta_scope());
        SqlMetaStatement metaStatement = null;

        artifactName.push(name); metaStatement = new SqlMetaStatement(); ((meta_scope)meta_stack.peek()).text = new StringBuilder(); ((meta_scope)meta_stack.peek()).typeFactory =_typeFactory; ((meta_scope)meta_stack.peek()).skip =_skip;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:204:2: ( sql[metaStatement] ( EOF )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:204:4: sql[metaStatement] ( EOF )?
            {
            pushFollow(FOLLOW_sql_in_meta315);
            sql(metaStatement);

            state._fsp--;

            // org/sqlproc/engine/impl/SqlProcessor.g:204:23: ( EOF )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case EOF:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:204:23: EOF
                    {
                    match(input,EOF,FOLLOW_EOF_in_meta318); 

                    }
                    break;

            }


            }

            metaStatement.setHasOutputMapping(((meta_scope)meta_stack.peek()).hasOutputMapping); artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            meta_stack.pop();
        }
        return metaStatement;
    }
    // $ANTLR end "meta"


    // $ANTLR start "sql"
    // org/sqlproc/engine/impl/SqlProcessor.g:207:1: sql[SqlMetaStatement metaStatement] : (~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | PERCENT ( PERCENT dbtab= dbtable ( sql[metaStatement] )? | dbcol= dbcolumn ( sql[metaStatement] )? ) | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? );
    public final void sql(SqlMetaStatement metaStatement) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;

        SqlDatabaseTable dbtab = null;

        SqlDatabaseColumn dbcol = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:209:2: (~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | PERCENT ( PERCENT dbtab= dbtable ( sql[metaStatement] )? | dbcol= dbcolumn ( sql[metaStatement] )? ) | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? )
            int alt18=6;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case MAPPING:
            case OPTION:
            case RBRACE:
            case QUESTI:
            case BAND:
            case BOR:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ML_COMMENT:
            case SL_COMMENT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_PERCENT:
            case ESC_DOT:
            case ESC_CHAR:
            case REST:
                {
                alt18=1;
                }
                break;
            case COLON:
                {
                alt18=2;
                }
                break;
            case STRING:
                {
                alt18=3;
                }
                break;
            case AT:
                {
                alt18=4;
                }
                break;
            case PERCENT:
                {
                alt18=5;
                }
                break;
            case LBRACE:
                {
                alt18=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }

            switch (alt18) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:210:2: ~ ( COLON | STRING | AT | PERCENT | LBRACE | SEMICOLON ) ( sql[metaStatement] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=EQUALS)||(input.LA(1)>=MAPPING && input.LA(1)<=OPTION)||(input.LA(1)>=RBRACE && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:211:40: ( sql[metaStatement] )?
                    int alt10=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt10=1;
                            }
                            break;
                    }

                    switch (alt10) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:211:40: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql369);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:212:4: COLON ident= identifier ( sql[metaStatement] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_sql376); 
                    pushFollow(FOLLOW_identifier_in_sql380);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(metaStatement, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:213:67: ( sql[metaStatement] )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:213:67: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql387);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:214:9: STRING cnst= constant ( sql[metaStatement] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_sql399); 
                    pushFollow(FOLLOW_constant_in_sql403);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(metaStatement, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:215:74: ( sql[metaStatement] )?
                    int alt12=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt12=1;
                            }
                            break;
                    }

                    switch (alt12) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:215:74: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql415);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:216:9: AT col= column ( sql[metaStatement] )?
                    {
                    match(input,AT,FOLLOW_AT_in_sql427); 
                    pushFollow(FOLLOW_column_in_sql431);
                    col=column();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addColumn(metaStatement, col, ((meta_scope)meta_stack.peek()).text);((meta_scope)meta_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlProcessor.g:217:100: ( sql[metaStatement] )?
                    int alt13=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt13=1;
                            }
                            break;
                    }

                    switch (alt13) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:217:100: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql443);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:218:5: PERCENT ( PERCENT dbtab= dbtable ( sql[metaStatement] )? | dbcol= dbcolumn ( sql[metaStatement] )? )
                    {
                    match(input,PERCENT,FOLLOW_PERCENT_in_sql451); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:218:13: ( PERCENT dbtab= dbtable ( sql[metaStatement] )? | dbcol= dbcolumn ( sql[metaStatement] )? )
                    int alt16=2;
                    switch ( input.LA(1) ) {
                    case PERCENT:
                        {
                        alt16=1;
                        }
                        break;
                    case IDENT:
                    case IDENT_DOT:
                        {
                        alt16=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 16, 0, input);

                        throw nvae;
                    }

                    switch (alt16) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:218:14: PERCENT dbtab= dbtable ( sql[metaStatement] )?
                            {
                            match(input,PERCENT,FOLLOW_PERCENT_in_sql454); 
                            pushFollow(FOLLOW_dbtable_in_sql458);
                            dbtab=dbtable();

                            state._fsp--;

                            if(!((meta_scope)meta_stack.peek()).skip) addDatabaseTable(metaStatement, dbtab, ((meta_scope)meta_stack.peek()).text);
                            // org/sqlproc/engine/impl/SqlProcessor.g:218:108: ( sql[metaStatement] )?
                            int alt14=2;
                            switch ( input.LA(1) ) {
                                case WS:
                                case IDENT:
                                case LPAREN:
                                case STATEMENT:
                                case COMMA:
                                case RPAREN:
                                case EQUALS:
                                case MAPPING:
                                case OPTION:
                                case COLON:
                                case STRING:
                                case AT:
                                case PERCENT:
                                case LBRACE:
                                case RBRACE:
                                case QUESTI:
                                case BAND:
                                case BOR:
                                case HASH:
                                case NUMBER:
                                case AND:
                                case OR:
                                case NOT:
                                case IDENT_DOT:
                                case CARET:
                                case PLUS:
                                case MINUS:
                                case LESS_THAN:
                                case MORE_THAN:
                                case DOT:
                                case DIGIT:
                                case ML_COMMENT:
                                case SL_COMMENT:
                                case ESC_COLON:
                                case ESC_SEMICOLON:
                                case ESC_STRING:
                                case ESC_LBRACE:
                                case ESC_RBRACE:
                                case ESC_BOR:
                                case ESC_HASH:
                                case ESC_AT:
                                case ESC_PERCENT:
                                case ESC_DOT:
                                case ESC_CHAR:
                                case REST:
                                    {
                                    alt14=1;
                                    }
                                    break;
                            }

                            switch (alt14) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:218:108: sql[metaStatement]
                                    {
                                    pushFollow(FOLLOW_sql_in_sql462);
                                    sql(metaStatement);

                                    state._fsp--;


                                    }
                                    break;

                            }


                            }
                            break;
                        case 2 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:219:16: dbcol= dbcolumn ( sql[metaStatement] )?
                            {
                            pushFollow(FOLLOW_dbcolumn_in_sql484);
                            dbcol=dbcolumn();

                            state._fsp--;

                            if(!((meta_scope)meta_stack.peek()).skip) addDatabaseColumn(metaStatement, dbcol, ((meta_scope)meta_stack.peek()).text);
                            // org/sqlproc/engine/impl/SqlProcessor.g:219:104: ( sql[metaStatement] )?
                            int alt15=2;
                            switch ( input.LA(1) ) {
                                case WS:
                                case IDENT:
                                case LPAREN:
                                case STATEMENT:
                                case COMMA:
                                case RPAREN:
                                case EQUALS:
                                case MAPPING:
                                case OPTION:
                                case COLON:
                                case STRING:
                                case AT:
                                case PERCENT:
                                case LBRACE:
                                case RBRACE:
                                case QUESTI:
                                case BAND:
                                case BOR:
                                case HASH:
                                case NUMBER:
                                case AND:
                                case OR:
                                case NOT:
                                case IDENT_DOT:
                                case CARET:
                                case PLUS:
                                case MINUS:
                                case LESS_THAN:
                                case MORE_THAN:
                                case DOT:
                                case DIGIT:
                                case ML_COMMENT:
                                case SL_COMMENT:
                                case ESC_COLON:
                                case ESC_SEMICOLON:
                                case ESC_STRING:
                                case ESC_LBRACE:
                                case ESC_RBRACE:
                                case ESC_BOR:
                                case ESC_HASH:
                                case ESC_AT:
                                case ESC_PERCENT:
                                case ESC_DOT:
                                case ESC_CHAR:
                                case REST:
                                    {
                                    alt15=1;
                                    }
                                    break;
                            }

                            switch (alt15) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:219:104: sql[metaStatement]
                                    {
                                    pushFollow(FOLLOW_sql_in_sql488);
                                    sql(metaStatement);

                                    state._fsp--;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 6 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:220:9: LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_sql501); 
                    pushFollow(FOLLOW_metaSql_in_sql503);
                    metaSql(metaStatement);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_sql506); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:220:46: ( sql[metaStatement] )?
                    int alt17=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case RBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt17=1;
                            }
                            break;
                    }

                    switch (alt17) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:220:46: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql508);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(metaStatement, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "sql"


    // $ANTLR start "metaSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:223:1: metaSql[SqlMetaStatement metaStatement] : (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] );
    public final void metaSql(SqlMetaStatement metaStatement) throws RecognitionException {
        Token fragmentType=null;
        Token orderId=null;
        SqlMetaIfItem metaIfItem = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; SqlMetaOrd metaOrd; SqlMetaSqlFragment sqlFragment; if(!((meta_scope)meta_stack.peek()).skip) addText(metaStatement, ((meta_scope)meta_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:225:2: (~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] )
            int alt24=6;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case COLON:
            case STRING:
            case AT:
            case PERCENT:
            case LBRACE:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ML_COMMENT:
            case SL_COMMENT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_PERCENT:
            case ESC_DOT:
            case ESC_CHAR:
            case REST:
                {
                alt24=1;
                }
                break;
            case QUESTI:
                {
                alt24=2;
                }
                break;
            case BAND:
                {
                alt24=3;
                }
                break;
            case BOR:
                {
                alt24=4;
                }
                break;
            case EQUALS:
                {
                alt24=5;
                }
                break;
            case HASH:
                {
                alt24=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;
            }

            switch (alt24) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:226:2: ~ ( QUESTI | BAND | BOR | EQUALS | HASH | RBRACE ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=RPAREN)||(input.LA(1)>=SEMICOLON && input.LA(1)<=LBRACE)||(input.LA(1)>=NUMBER && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_metaSql566);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:228:3: ( BOR metaIfItem= ifSql[null] )*
                    loop19:
                    do {
                        int alt19=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt19=1;
                            }
                            break;

                        }

                        switch (alt19) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:228:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql575); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql579);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop19;
                        }
                    } while (true);

                    metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:229:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_metaSql591); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_metaSql597);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_metaSql604); 
                    pushFollow(FOLLOW_ifSql_in_metaSql608);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:231:3: ( BOR metaIfItem= ifSql[null] )*
                    loop20:
                    do {
                        int alt20=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt20=1;
                            }
                            break;

                        }

                        switch (alt20) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:231:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql617); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql621);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop20;
                        }
                    } while (true);

                    metaStatement.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:233:4: BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_metaSql636); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_metaSql642);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:234:3: ( BOR metaIfItem= ifSql[null] )*
                    loop21:
                    do {
                        int alt21=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt21=1;
                            }
                            break;

                        }

                        switch (alt21) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:234:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql651); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql655);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop21;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:235:4: BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_metaSql667); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_metaSql673);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlProcessor.g:236:3: ( BOR metaIfItem= ifSql[null] )*
                    loop22:
                    do {
                        int alt22=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt22=1;
                            }
                            break;

                        }

                        switch (alt22) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:236:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql682); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql686);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop22;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:237:4: EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null]
                    {
                    match(input,EQUALS,FOLLOW_EQUALS_in_metaSql698); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:237:11: ( WS )*
                    loop23:
                    do {
                        int alt23=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt23=1;
                            }
                            break;

                        }

                        switch (alt23) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:237:11: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_metaSql700); 

                    	    }
                    	    break;

                    	default :
                    	    break loop23;
                        }
                    } while (true);

                    fragmentType=(Token)match(input,IDENT,FOLLOW_IDENT_in_metaSql705); 
                    sqlFragment = new SqlMetaSqlFragment(fragmentType.getText());
                    pushFollow(FOLLOW_ifSql_in_metaSql711);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) sqlFragment.addElement(metaIfItem);
                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(sqlFragment);

                    }
                    break;
                case 6 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:239:4: HASH orderId= NUMBER ordSql[metaOrd]
                    {
                    match(input,HASH,FOLLOW_HASH_in_metaSql724); 
                    orderId=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_metaSql728); 
                    metaOrd = new SqlMetaOrd(Integer.parseInt(orderId.getText()));
                    pushFollow(FOLLOW_ordSql_in_metaSql732);
                    ordSql(metaOrd);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaStatement.addElement(metaOrd);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "metaSql"


    // $ANTLR start "ifSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:242:1: ifSql[SqlMetaIfItem metaIfItemIn] returns [SqlMetaIfItem metaIfItem] : (~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | PERCENT ( PERCENT dbtab= dbtable ( ifSql[metaIfItem] )? | dbcol= dbcolumn ( ifSql[metaIfItem] )? ) | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? );
    public final SqlMetaIfItem ifSql(SqlMetaIfItem metaIfItemIn) throws RecognitionException {
        SqlMetaIfItem metaIfItem = null;

        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;

        SqlDatabaseTable dbtab = null;

        SqlDatabaseColumn dbcol = null;


        metaIfItem = (metaIfItemIn !=null) ? metaIfItemIn : new SqlMetaIfItem();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:245:2: (~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | PERCENT ( PERCENT dbtab= dbtable ( ifSql[metaIfItem] )? | dbcol= dbcolumn ( ifSql[metaIfItem] )? ) | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? )
            int alt33=6;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case QUESTI:
            case BAND:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ML_COMMENT:
            case SL_COMMENT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_PERCENT:
            case ESC_DOT:
            case ESC_CHAR:
            case REST:
                {
                alt33=1;
                }
                break;
            case COLON:
                {
                alt33=2;
                }
                break;
            case STRING:
                {
                alt33=3;
                }
                break;
            case AT:
                {
                alt33=4;
                }
                break;
            case PERCENT:
                {
                alt33=5;
                }
                break;
            case LBRACE:
                {
                alt33=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }

            switch (alt33) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:246:2: ~ ( COLON | STRING | AT | PERCENT | LBRACE | BOR | RBRACE ) ( ifSql[metaIfItem] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=OPTION)||(input.LA(1)>=QUESTI && input.LA(1)<=BAND)||(input.LA(1)>=HASH && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:247:40: ( ifSql[metaIfItem] )?
                    int alt25=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt25=1;
                            }
                            break;
                    }

                    switch (alt25) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:247:40: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql796);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:248:4: COLON ident= identifier ( ifSql[metaIfItem] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ifSql803); 
                    pushFollow(FOLLOW_identifier_in_ifSql807);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(metaIfItem, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:249:64: ( ifSql[metaIfItem] )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:249:64: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql814);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:250:4: STRING cnst= constant ( ifSql[metaIfItem] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ifSql821); 
                    pushFollow(FOLLOW_constant_in_ifSql825);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(metaIfItem, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:251:66: ( ifSql[metaIfItem] )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:251:66: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql832);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:252:9: AT col= column ( ifSql[metaIfItem] )?
                    {
                    match(input,AT,FOLLOW_AT_in_ifSql844); 
                    pushFollow(FOLLOW_column_in_ifSql848);
                    col=column();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addColumn(metaIfItem, col, ((meta_scope)meta_stack.peek()).text);((meta_scope)meta_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlProcessor.g:253:97: ( ifSql[metaIfItem] )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:253:97: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql860);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:254:4: PERCENT ( PERCENT dbtab= dbtable ( ifSql[metaIfItem] )? | dbcol= dbcolumn ( ifSql[metaIfItem] )? )
                    {
                    match(input,PERCENT,FOLLOW_PERCENT_in_ifSql867); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:254:12: ( PERCENT dbtab= dbtable ( ifSql[metaIfItem] )? | dbcol= dbcolumn ( ifSql[metaIfItem] )? )
                    int alt31=2;
                    switch ( input.LA(1) ) {
                    case PERCENT:
                        {
                        alt31=1;
                        }
                        break;
                    case IDENT:
                    case IDENT_DOT:
                        {
                        alt31=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 31, 0, input);

                        throw nvae;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:254:13: PERCENT dbtab= dbtable ( ifSql[metaIfItem] )?
                            {
                            match(input,PERCENT,FOLLOW_PERCENT_in_ifSql870); 
                            pushFollow(FOLLOW_dbtable_in_ifSql874);
                            dbtab=dbtable();

                            state._fsp--;

                            if(!((meta_scope)meta_stack.peek()).skip) addDatabaseTable(metaIfItem, dbtab, ((meta_scope)meta_stack.peek()).text);
                            // org/sqlproc/engine/impl/SqlProcessor.g:254:104: ( ifSql[metaIfItem] )?
                            int alt29=2;
                            switch ( input.LA(1) ) {
                                case WS:
                                case IDENT:
                                case LPAREN:
                                case STATEMENT:
                                case COMMA:
                                case RPAREN:
                                case EQUALS:
                                case SEMICOLON:
                                case MAPPING:
                                case OPTION:
                                case COLON:
                                case STRING:
                                case AT:
                                case PERCENT:
                                case LBRACE:
                                case QUESTI:
                                case BAND:
                                case HASH:
                                case NUMBER:
                                case AND:
                                case OR:
                                case NOT:
                                case IDENT_DOT:
                                case CARET:
                                case PLUS:
                                case MINUS:
                                case LESS_THAN:
                                case MORE_THAN:
                                case DOT:
                                case DIGIT:
                                case ML_COMMENT:
                                case SL_COMMENT:
                                case ESC_COLON:
                                case ESC_SEMICOLON:
                                case ESC_STRING:
                                case ESC_LBRACE:
                                case ESC_RBRACE:
                                case ESC_BOR:
                                case ESC_HASH:
                                case ESC_AT:
                                case ESC_PERCENT:
                                case ESC_DOT:
                                case ESC_CHAR:
                                case REST:
                                    {
                                    alt29=1;
                                    }
                                    break;
                            }

                            switch (alt29) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:254:104: ifSql[metaIfItem]
                                    {
                                    pushFollow(FOLLOW_ifSql_in_ifSql878);
                                    ifSql(metaIfItem);

                                    state._fsp--;


                                    }
                                    break;

                            }


                            }
                            break;
                        case 2 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:255:16: dbcol= dbcolumn ( ifSql[metaIfItem] )?
                            {
                            pushFollow(FOLLOW_dbcolumn_in_ifSql900);
                            dbcol=dbcolumn();

                            state._fsp--;

                            if(!((meta_scope)meta_stack.peek()).skip) addDatabaseColumn(metaIfItem, dbcol, ((meta_scope)meta_stack.peek()).text);
                            // org/sqlproc/engine/impl/SqlProcessor.g:255:101: ( ifSql[metaIfItem] )?
                            int alt30=2;
                            switch ( input.LA(1) ) {
                                case WS:
                                case IDENT:
                                case LPAREN:
                                case STATEMENT:
                                case COMMA:
                                case RPAREN:
                                case EQUALS:
                                case SEMICOLON:
                                case MAPPING:
                                case OPTION:
                                case COLON:
                                case STRING:
                                case AT:
                                case PERCENT:
                                case LBRACE:
                                case QUESTI:
                                case BAND:
                                case HASH:
                                case NUMBER:
                                case AND:
                                case OR:
                                case NOT:
                                case IDENT_DOT:
                                case CARET:
                                case PLUS:
                                case MINUS:
                                case LESS_THAN:
                                case MORE_THAN:
                                case DOT:
                                case DIGIT:
                                case ML_COMMENT:
                                case SL_COMMENT:
                                case ESC_COLON:
                                case ESC_SEMICOLON:
                                case ESC_STRING:
                                case ESC_LBRACE:
                                case ESC_RBRACE:
                                case ESC_BOR:
                                case ESC_HASH:
                                case ESC_AT:
                                case ESC_PERCENT:
                                case ESC_DOT:
                                case ESC_CHAR:
                                case REST:
                                    {
                                    alt30=1;
                                    }
                                    break;
                            }

                            switch (alt30) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:255:101: ifSql[metaIfItem]
                                    {
                                    pushFollow(FOLLOW_ifSql_in_ifSql904);
                                    ifSql(metaIfItem);

                                    state._fsp--;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 6 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:256:4: LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_ifSql912); 
                    pushFollow(FOLLOW_ifMetaSql_in_ifSql914);
                    ifMetaSql(metaIfItem);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_ifSql917); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:256:40: ( ifSql[metaIfItem] )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:256:40: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql919);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(metaIfItem, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaIfItem;
    }
    // $ANTLR end "ifSql"


    // $ANTLR start "ifMetaSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:259:1: ifMetaSql[SqlMetaIfItem metaIfItem] : (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* );
    public final void ifMetaSql(SqlMetaIfItem metaIfItem) throws RecognitionException {
        SqlMetaIfItem metaIfItem2 = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; if(!((meta_scope)meta_stack.peek()).skip) addText(metaIfItem, ((meta_scope)meta_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:261:2: (~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* )
            int alt38=4;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case COLON:
            case STRING:
            case AT:
            case PERCENT:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ML_COMMENT:
            case SL_COMMENT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_PERCENT:
            case ESC_DOT:
            case ESC_CHAR:
            case REST:
                {
                alt38=1;
                }
                break;
            case QUESTI:
                {
                alt38=2;
                }
                break;
            case BAND:
                {
                alt38=3;
                }
                break;
            case BOR:
                {
                alt38=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;
            }

            switch (alt38) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:262:2: ~ ( QUESTI | BAND | BOR | LBRACE | RBRACE ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=PERCENT)||(input.LA(1)>=HASH && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql974);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:264:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop34:
                    do {
                        int alt34=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt34=1;
                            }
                            break;

                        }

                        switch (alt34) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:264:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql983); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql987);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop34;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:265:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_ifMetaSql999); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifMetaSql1005);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1012); 
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql1016);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:267:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop35:
                    do {
                        int alt35=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt35=1;
                            }
                            break;

                        }

                        switch (alt35) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:267:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1025); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql1029);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaIf.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop35;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:269:4: BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_ifMetaSql1044); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql1050);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:270:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop36:
                    do {
                        int alt36=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt36=1;
                            }
                            break;

                        }

                        switch (alt36) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:270:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1059); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql1063);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop36;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:271:4: BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1075); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql1081);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlProcessor.g:272:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop37:
                    do {
                        int alt37=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt37=1;
                            }
                            break;

                        }

                        switch (alt37) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:272:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1090); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql1094);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    if(!((meta_scope)meta_stack.peek()).skip) metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop37;
                        }
                    } while (true);

                    if(!((meta_scope)meta_stack.peek()).skip) metaIfItem.addElement(metaAndOr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifMetaSql"


    // $ANTLR start "ifSqlCond"
    // org/sqlproc/engine/impl/SqlProcessor.g:275:1: ifSqlCond returns [SqlMetaLogExpr metaLogExpr] : ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* ;
    public final SqlMetaLogExpr ifSqlCond() throws RecognitionException {
        SqlMetaLogExpr metaLogExpr = null;

        metaLogExpr = new SqlMetaLogExpr();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:277:2: ( ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* )
            // org/sqlproc/engine/impl/SqlProcessor.g:278:2: ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:278:2: ( WS )*
            loop39:
            do {
                int alt39=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt39=1;
                    }
                    break;

                }

                switch (alt39) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:278:2: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1121); 

            	    }
            	    break;

            	default :
            	    break loop39;
                }
            } while (true);

            pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1124);
            ifSqlBool(metaLogExpr);

            state._fsp--;

            // org/sqlproc/engine/impl/SqlProcessor.g:278:29: ( WS )*
            loop40:
            do {
                int alt40=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt40=1;
                    }
                    break;

                }

                switch (alt40) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:278:29: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1127); 

            	    }
            	    break;

            	default :
            	    break loop40;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:278:33: ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            loop44:
            do {
                int alt44=2;
                switch ( input.LA(1) ) {
                case AND:
                case OR:
                    {
                    alt44=1;
                    }
                    break;

                }

                switch (alt44) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:278:34: ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )*
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:278:34: ( AND | OR )
            	    int alt41=2;
            	    switch ( input.LA(1) ) {
            	    case AND:
            	        {
            	        alt41=1;
            	        }
            	        break;
            	    case OR:
            	        {
            	        alt41=2;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 41, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt41) {
            	        case 1 :
            	            // org/sqlproc/engine/impl/SqlProcessor.g:278:35: AND
            	            {
            	            match(input,AND,FOLLOW_AND_in_ifSqlCond1132); 
            	            if(!((meta_scope)meta_stack.peek()).skip) addOperator(metaLogExpr,true);

            	            }
            	            break;
            	        case 2 :
            	            // org/sqlproc/engine/impl/SqlProcessor.g:278:91: OR
            	            {
            	            match(input,OR,FOLLOW_OR_in_ifSqlCond1138); 
            	            if(!((meta_scope)meta_stack.peek()).skip) addOperator(metaLogExpr,false);

            	            }
            	            break;

            	    }

            	    // org/sqlproc/engine/impl/SqlProcessor.g:278:146: ( WS )*
            	    loop42:
            	    do {
            	        int alt42=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt42=1;
            	            }
            	            break;

            	        }

            	        switch (alt42) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:278:146: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1143); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop42;
            	        }
            	    } while (true);

            	    pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1148);
            	    ifSqlBool(metaLogExpr);

            	    state._fsp--;

            	    // org/sqlproc/engine/impl/SqlProcessor.g:279:26: ( WS )*
            	    loop43:
            	    do {
            	        int alt43=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt43=1;
            	            }
            	            break;

            	        }

            	        switch (alt43) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:279:26: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1151); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop43;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop44;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaLogExpr;
    }
    // $ANTLR end "ifSqlCond"


    // $ANTLR start "ifSqlBool"
    // org/sqlproc/engine/impl/SqlProcessor.g:282:1: ifSqlBool[SqlMetaLogExpr metaLogExpr] : ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN );
    public final void ifSqlBool(SqlMetaLogExpr metaLogExpr) throws RecognitionException {
        Token not=null;
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMetaLogExpr newMetaLogExpr = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:283:2: ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN )
            int alt48=3;
            switch ( input.LA(1) ) {
            case NOT:
                {
                switch ( input.LA(2) ) {
                case COLON:
                    {
                    alt48=1;
                    }
                    break;
                case STRING:
                    {
                    alt48=2;
                    }
                    break;
                case LPAREN:
                    {
                    alt48=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 48, 1, input);

                    throw nvae;
                }

                }
                break;
            case COLON:
                {
                alt48=1;
                }
                break;
            case STRING:
                {
                alt48=2;
                }
                break;
            case LPAREN:
                {
                alt48=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }

            switch (alt48) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:284:2: (not= NOT )? COLON ident= identifier
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:284:5: (not= NOT )?
                    int alt45=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt45=1;
                            }
                            break;
                    }

                    switch (alt45) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:284:5: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1171); 

                            }
                            break;

                    }

                    match(input,COLON,FOLLOW_COLON_in_ifSqlBool1174); 
                    pushFollow(FOLLOW_identifier_in_ifSqlBool1178);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) {ident.setNot(not!=null); addIdent(metaLogExpr, ident, ((meta_scope)meta_stack.peek()).text);}

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:285:4: (not= NOT )? STRING cnst= constant
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:285:7: (not= NOT )?
                    int alt46=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt46=1;
                            }
                            break;
                    }

                    switch (alt46) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:285:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1187); 

                            }
                            break;

                    }

                    match(input,STRING,FOLLOW_STRING_in_ifSqlBool1190); 
                    pushFollow(FOLLOW_constant_in_ifSqlBool1194);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) {cnst.setNot(not!=null); addConstant(metaLogExpr, cnst, ((meta_scope)meta_stack.peek()).text);}

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:286:4: (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN
                    {
                    // org/sqlproc/engine/impl/SqlProcessor.g:286:7: (not= NOT )?
                    int alt47=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt47=1;
                            }
                            break;
                    }

                    switch (alt47) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:286:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1203); 

                            }
                            break;

                    }

                    match(input,LPAREN,FOLLOW_LPAREN_in_ifSqlBool1206); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifSqlBool1210);
                    newMetaLogExpr=ifSqlCond();

                    state._fsp--;

                    match(input,RPAREN,FOLLOW_RPAREN_in_ifSqlBool1212); 
                    if(!((meta_scope)meta_stack.peek()).skip) metaLogExpr.addElement(newMetaLogExpr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifSqlBool"


    // $ANTLR start "ordSql"
    // org/sqlproc/engine/impl/SqlProcessor.g:289:1: ordSql[SqlMetaOrd ord] : (~ ( COLON | STRING | PERCENT | RBRACE ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? | PERCENT dbcol= dbcolumn ( ordSql[ord] )? );
    public final void ordSql(SqlMetaOrd ord) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlDatabaseColumn dbcol = null;


        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:291:3: (~ ( COLON | STRING | PERCENT | RBRACE ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? | PERCENT dbcol= dbcolumn ( ordSql[ord] )? )
            int alt53=4;
            switch ( input.LA(1) ) {
            case WS:
            case IDENT:
            case LPAREN:
            case STATEMENT:
            case COMMA:
            case RPAREN:
            case EQUALS:
            case SEMICOLON:
            case MAPPING:
            case OPTION:
            case AT:
            case LBRACE:
            case QUESTI:
            case BAND:
            case BOR:
            case HASH:
            case NUMBER:
            case AND:
            case OR:
            case NOT:
            case IDENT_DOT:
            case CARET:
            case PLUS:
            case MINUS:
            case LESS_THAN:
            case MORE_THAN:
            case DOT:
            case DIGIT:
            case ML_COMMENT:
            case SL_COMMENT:
            case ESC_COLON:
            case ESC_SEMICOLON:
            case ESC_STRING:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_BOR:
            case ESC_HASH:
            case ESC_AT:
            case ESC_PERCENT:
            case ESC_DOT:
            case ESC_CHAR:
            case REST:
                {
                alt53=1;
                }
                break;
            case COLON:
                {
                alt53=2;
                }
                break;
            case STRING:
                {
                alt53=3;
                }
                break;
            case PERCENT:
                {
                alt53=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }

            switch (alt53) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:292:2: ~ ( COLON | STRING | PERCENT | RBRACE ) ( ordSql[ord] )?
                    {
                    if ( (input.LA(1)>=WS && input.LA(1)<=OPTION)||input.LA(1)==AT||input.LA(1)==LBRACE||(input.LA(1)>=QUESTI && input.LA(1)<=REST) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    if(!((meta_scope)meta_stack.peek()).skip) add(((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:293:40: ( ordSql[ord] )?
                    int alt49=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt49=1;
                            }
                            break;
                    }

                    switch (alt49) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:293:40: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1257);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:294:4: COLON ident= identifier ( ordSql[ord] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ordSql1264); 
                    pushFollow(FOLLOW_identifier_in_ordSql1268);
                    ident=identifier();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addIdent(ord, ident, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:295:57: ( ordSql[ord] )?
                    int alt50=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt50=1;
                            }
                            break;
                    }

                    switch (alt50) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:295:57: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1275);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:296:4: STRING cnst= constant ( ordSql[ord] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ordSql1282); 
                    pushFollow(FOLLOW_constant_in_ordSql1286);
                    cnst=constant();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addConstant(ord, cnst, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:297:59: ( ordSql[ord] )?
                    int alt51=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt51=1;
                            }
                            break;
                    }

                    switch (alt51) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:297:59: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1292);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:298:4: PERCENT dbcol= dbcolumn ( ordSql[ord] )?
                    {
                    match(input,PERCENT,FOLLOW_PERCENT_in_ordSql1299); 
                    pushFollow(FOLLOW_dbcolumn_in_ordSql1303);
                    dbcol=dbcolumn();

                    state._fsp--;

                    if(!((meta_scope)meta_stack.peek()).skip) addDatabaseColumn(ord, dbcol, ((meta_scope)meta_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlProcessor.g:299:66: ( ordSql[ord] )?
                    int alt52=2;
                    switch ( input.LA(1) ) {
                        case WS:
                        case IDENT:
                        case LPAREN:
                        case STATEMENT:
                        case COMMA:
                        case RPAREN:
                        case EQUALS:
                        case SEMICOLON:
                        case MAPPING:
                        case OPTION:
                        case COLON:
                        case STRING:
                        case AT:
                        case PERCENT:
                        case LBRACE:
                        case QUESTI:
                        case BAND:
                        case BOR:
                        case HASH:
                        case NUMBER:
                        case AND:
                        case OR:
                        case NOT:
                        case IDENT_DOT:
                        case CARET:
                        case PLUS:
                        case MINUS:
                        case LESS_THAN:
                        case MORE_THAN:
                        case DOT:
                        case DIGIT:
                        case ML_COMMENT:
                        case SL_COMMENT:
                        case ESC_COLON:
                        case ESC_SEMICOLON:
                        case ESC_STRING:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_BOR:
                        case ESC_HASH:
                        case ESC_AT:
                        case ESC_PERCENT:
                        case ESC_DOT:
                        case ESC_CHAR:
                        case REST:
                            {
                            alt52=1;
                            }
                            break;
                    }

                    switch (alt52) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:299:66: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1309);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            if(!((meta_scope)meta_stack.peek()).skip) addText(ord, ((meta_scope)meta_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ordSql"


    // $ANTLR start "column"
    // org/sqlproc/engine/impl/SqlProcessor.g:302:1: column returns [SqlMappingItem result] : (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMappingItem column() throws RecognitionException {
        SqlMappingItem result = null;

        Token col=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:304:2: ( (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:305:2: (col= IDENT_DOT | col= IDENT | col= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:305:2: (col= IDENT_DOT | col= IDENT | col= NUMBER )
            int alt54=3;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt54=1;
                }
                break;
            case IDENT:
                {
                alt54=2;
                }
                break;
            case NUMBER:
                {
                alt54=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;
            }

            switch (alt54) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:305:3: col= IDENT_DOT
                    {
                    col=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_column1336); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:305:19: col= IDENT
                    {
                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1342); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:305:31: col= NUMBER
                    {
                    col=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1348); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newColumn(col);
            // org/sqlproc/engine/impl/SqlProcessor.g:306:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt58=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt58=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt58) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:306:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_column1364); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1368); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:307:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop57:
                    do {
                        int alt57=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt57=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt57=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt57) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:307:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_column1384); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:307:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt56=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt56=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt56=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 56, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt56) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:307:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1389); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:307:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt55=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt55=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt55) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:307:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_column1400); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1404); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:307:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1412); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop57;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "column"


    // $ANTLR start "constant"
    // org/sqlproc/engine/impl/SqlProcessor.g:312:1: constant returns [SqlMetaConst result] : (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaConst constant() throws RecognitionException {
        SqlMetaConst result = null;

        Token caseCnst=null;
        Token cnst=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:314:2: ( (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:315:2: (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:315:2: (caseCnst= PLUS | caseCnst= MINUS )?
            int alt59=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt59=1;
                    }
                    break;
                case MINUS:
                    {
                    alt59=2;
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:315:3: caseCnst= PLUS
                    {
                    caseCnst=(Token)match(input,PLUS,FOLLOW_PLUS_in_constant1449); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:315:19: caseCnst= MINUS
                    {
                    caseCnst=(Token)match(input,MINUS,FOLLOW_MINUS_in_constant1455); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:315:36: (cnst= IDENT_DOT | cnst= IDENT )
            int alt60=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt60=1;
                }
                break;
            case IDENT:
                {
                alt60=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;
            }

            switch (alt60) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:315:37: cnst= IDENT_DOT
                    {
                    cnst=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_constant1462); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:315:54: cnst= IDENT
                    {
                    cnst=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1468); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newConstant(cnst, caseCnst);
            // org/sqlproc/engine/impl/SqlProcessor.g:316:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt64=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt64=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt64) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:316:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_constant1484); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1488); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:317:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop63:
                    do {
                        int alt63=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt63=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt63=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt63) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:317:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_constant1504); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:317:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt62=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt62=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt62=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 62, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt62) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:317:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1509); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:317:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt61=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt61=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt61) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:317:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_constant1520); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1524); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:317:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_constant1532); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop63;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "constant"


    // $ANTLR start "identifier"
    // org/sqlproc/engine/impl/SqlProcessor.g:322:1: identifier returns [SqlMetaIdent result] : (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaIdent identifier() throws RecognitionException {
        SqlMetaIdent result = null;

        Token modeIdent=null;
        Token caseIdent=null;
        Token ident=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:324:2: ( (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:325:2: (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )? (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT | ident= NUMBER ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:325:2: (modeIdent= EQUALS | modeIdent= LESS_THAN | modeIdent= MORE_THAN )?
            int alt65=4;
            switch ( input.LA(1) ) {
                case EQUALS:
                    {
                    alt65=1;
                    }
                    break;
                case LESS_THAN:
                    {
                    alt65=2;
                    }
                    break;
                case MORE_THAN:
                    {
                    alt65=3;
                    }
                    break;
            }

            switch (alt65) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:3: modeIdent= EQUALS
                    {
                    modeIdent=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_identifier1569); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:22: modeIdent= LESS_THAN
                    {
                    modeIdent=(Token)match(input,LESS_THAN,FOLLOW_LESS_THAN_in_identifier1575); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:44: modeIdent= MORE_THAN
                    {
                    modeIdent=(Token)match(input,MORE_THAN,FOLLOW_MORE_THAN_in_identifier1581); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:325:66: (caseIdent= PLUS | caseIdent= MINUS )?
            int alt66=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt66=1;
                    }
                    break;
                case MINUS:
                    {
                    alt66=2;
                    }
                    break;
            }

            switch (alt66) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:67: caseIdent= PLUS
                    {
                    caseIdent=(Token)match(input,PLUS,FOLLOW_PLUS_in_identifier1588); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:84: caseIdent= MINUS
                    {
                    caseIdent=(Token)match(input,MINUS,FOLLOW_MINUS_in_identifier1594); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlProcessor.g:325:102: (ident= IDENT_DOT | ident= IDENT | ident= NUMBER )
            int alt67=3;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt67=1;
                }
                break;
            case IDENT:
                {
                alt67=2;
                }
                break;
            case NUMBER:
                {
                alt67=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 67, 0, input);

                throw nvae;
            }

            switch (alt67) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:103: ident= IDENT_DOT
                    {
                    ident=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_identifier1601); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:121: ident= IDENT
                    {
                    ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1607); 

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:325:135: ident= NUMBER
                    {
                    ident=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1613); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newIdent(ident, modeIdent, caseIdent);
            // org/sqlproc/engine/impl/SqlProcessor.g:326:2: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt71=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt71=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt71) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:326:28: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_identifier1629); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1633); 
                     if(!((meta_scope)meta_stack.peek()).skip) setMetaType(((meta_scope)meta_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:327:3: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop70:
                    do {
                        int alt70=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt70=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt70=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt70) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:327:29: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_identifier1649); 
                    	    // org/sqlproc/engine/impl/SqlProcessor.g:327:35: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt69=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt69=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt69=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 69, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt69) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:327:36: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1654); 
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:327:48: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt68=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt68=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt68) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlProcessor.g:327:73: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_identifier1665); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1669); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlProcessor.g:327:97: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1677); 

                    	            }
                    	            break;

                    	    }

                    	     if(!((meta_scope)meta_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop70;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "identifier"


    // $ANTLR start "dbcolumn"
    // org/sqlproc/engine/impl/SqlProcessor.g:333:1: dbcolumn returns [SqlDatabaseColumn result] : (dbcol= IDENT_DOT | dbcol= IDENT ) ;
    public final SqlDatabaseColumn dbcolumn() throws RecognitionException {
        SqlDatabaseColumn result = null;

        Token dbcol=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:335:2: ( (dbcol= IDENT_DOT | dbcol= IDENT ) )
            // org/sqlproc/engine/impl/SqlProcessor.g:336:2: (dbcol= IDENT_DOT | dbcol= IDENT )
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:336:2: (dbcol= IDENT_DOT | dbcol= IDENT )
            int alt72=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt72=1;
                }
                break;
            case IDENT:
                {
                alt72=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;
            }

            switch (alt72) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:336:3: dbcol= IDENT_DOT
                    {
                    dbcol=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_dbcolumn1714); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:336:21: dbcol= IDENT
                    {
                    dbcol=(Token)match(input,IDENT,FOLLOW_IDENT_in_dbcolumn1720); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newDatabaseColumn(dbcol);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "dbcolumn"


    // $ANTLR start "dbtable"
    // org/sqlproc/engine/impl/SqlProcessor.g:339:1: dbtable returns [SqlDatabaseTable result] : (dbtab= IDENT_DOT | dbtab= IDENT ) ;
    public final SqlDatabaseTable dbtable() throws RecognitionException {
        SqlDatabaseTable result = null;

        Token dbtab=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:341:2: ( (dbtab= IDENT_DOT | dbtab= IDENT ) )
            // org/sqlproc/engine/impl/SqlProcessor.g:342:2: (dbtab= IDENT_DOT | dbtab= IDENT )
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:342:2: (dbtab= IDENT_DOT | dbtab= IDENT )
            int alt73=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt73=1;
                }
                break;
            case IDENT:
                {
                alt73=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;
            }

            switch (alt73) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:342:3: dbtab= IDENT_DOT
                    {
                    dbtab=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_dbtable1747); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:342:21: dbtab= IDENT
                    {
                    dbtab=(Token)match(input,IDENT,FOLLOW_IDENT_in_dbtable1753); 

                    }
                    break;

            }

            if(!((meta_scope)meta_stack.peek()).skip) result = newDatabaseTable(dbtab);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "dbtable"

    protected static class mapping_scope {
        SqlTypeFactory typeFactory;
        boolean skip;
    }
    protected Stack mapping_stack = new Stack();


    // $ANTLR start "mapping"
    // org/sqlproc/engine/impl/SqlProcessor.g:346:1: mapping[String name, SqlTypeFactory _typeFactory, boolean _skip] returns [SqlMappingRule sqlMapping] : ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) ;
    public final SqlMappingRule mapping(String name, SqlTypeFactory _typeFactory, boolean _skip) throws RecognitionException {
        mapping_stack.push(new mapping_scope());
        SqlMappingRule sqlMapping = null;

        SqlMappingItem sqlMappingItem = null;


        artifactName.push(name); sqlMapping = new SqlMappingRule();((mapping_scope)mapping_stack.peek()).typeFactory =_typeFactory; ((mapping_scope)mapping_stack.peek()).skip =_skip;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:350:1: ( ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? ) )
            // org/sqlproc/engine/impl/SqlProcessor.g:351:1: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:351:1: ( ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:352:3: ( WS )* sqlMappingItem= mappingItem ( ( WS )+ sqlMappingItem= mappingItem )* ( WS )* ( EOF )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:352:3: ( WS )*
            loop74:
            do {
                int alt74=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt74=1;
                    }
                    break;

                }

                switch (alt74) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:352:3: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_mapping1791); 

            	    }
            	    break;

            	default :
            	    break loop74;
                }
            } while (true);

            pushFollow(FOLLOW_mappingItem_in_mapping1798);
            sqlMappingItem=mappingItem();

            state._fsp--;

            if(!((mapping_scope)mapping_stack.peek()).skip) sqlMapping.addMapping(sqlMappingItem);
            // org/sqlproc/engine/impl/SqlProcessor.g:354:3: ( ( WS )+ sqlMappingItem= mappingItem )*
            loop76:
            do {
                int alt76=2;
                alt76 = dfa76.predict(input);
                switch (alt76) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:354:4: ( WS )+ sqlMappingItem= mappingItem
            	    {
            	    // org/sqlproc/engine/impl/SqlProcessor.g:354:4: ( WS )+
            	    int cnt75=0;
            	    loop75:
            	    do {
            	        int alt75=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt75=1;
            	            }
            	            break;

            	        }

            	        switch (alt75) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlProcessor.g:354:4: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_mapping1805); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    if ( cnt75 >= 1 ) break loop75;
            	                EarlyExitException eee =
            	                    new EarlyExitException(75, input);
            	                throw eee;
            	        }
            	        cnt75++;
            	    } while (true);

            	    pushFollow(FOLLOW_mappingItem_in_mapping1810);
            	    sqlMappingItem=mappingItem();

            	    state._fsp--;

            	    if(!((mapping_scope)mapping_stack.peek()).skip) sqlMapping.addMapping(sqlMappingItem);

            	    }
            	    break;

            	default :
            	    break loop76;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:355:3: ( WS )*
            loop77:
            do {
                int alt77=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt77=1;
                    }
                    break;

                }

                switch (alt77) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:355:3: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_mapping1818); 

            	    }
            	    break;

            	default :
            	    break loop77;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlProcessor.g:355:8: ( EOF )?
            int alt78=2;
            switch ( input.LA(1) ) {
                case EOF:
                    {
                    alt78=1;
                    }
                    break;
            }

            switch (alt78) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:355:8: EOF
                    {
                    match(input,EOF,FOLLOW_EOF_in_mapping1822); 

                    }
                    break;

            }


            }


            }

             artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            mapping_stack.pop();
        }
        return sqlMapping;
    }
    // $ANTLR end "mapping"


    // $ANTLR start "mappingItem"
    // org/sqlproc/engine/impl/SqlProcessor.g:359:1: mappingItem returns [SqlMappingItem result] : (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )? ;
    public final SqlMappingItem mappingItem() throws RecognitionException {
        SqlMappingItem result = null;

        Token col=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        result = null;
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:361:2: ( (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )? )
            // org/sqlproc/engine/impl/SqlProcessor.g:362:2: (col= IDENT | col= NUMBER ) ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )?
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:362:2: (col= IDENT | col= NUMBER )
            int alt79=2;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt79=1;
                }
                break;
            case NUMBER:
                {
                alt79=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 79, 0, input);

                throw nvae;
            }

            switch (alt79) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:362:3: col= IDENT
                    {
                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1848); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:362:15: col= NUMBER
                    {
                    col=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem1854); 

                    }
                    break;

            }

            if(!((mapping_scope)mapping_stack.peek()).skip) result = newColumn(col);
            // org/sqlproc/engine/impl/SqlProcessor.g:363:3: ( options {greedy=true; } : STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )?
            int alt86=2;
            switch ( input.LA(1) ) {
                case STRING:
                    {
                    alt86=1;
                    }
                    break;
            }

            switch (alt86) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlProcessor.g:363:29: STRING (type= IDENT )? ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_mappingItem1871); 
                    // org/sqlproc/engine/impl/SqlProcessor.g:363:36: (type= IDENT )?
                    int alt80=2;
                    switch ( input.LA(1) ) {
                        case IDENT:
                            {
                            alt80=1;
                            }
                            break;
                    }

                    switch (alt80) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:363:37: type= IDENT
                            {
                            type=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1876); 
                             if(!((mapping_scope)mapping_stack.peek()).skip) setMetaType(((mapping_scope)mapping_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 

                            }
                            break;

                    }

                    // org/sqlproc/engine/impl/SqlProcessor.g:364:4: ( STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
                    int alt85=2;
                    switch ( input.LA(1) ) {
                        case STRING:
                            {
                            alt85=1;
                            }
                            break;
                    }

                    switch (alt85) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlProcessor.g:364:5: STRING (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                            {
                            match(input,STRING,FOLLOW_STRING_in_mappingItem1886); 
                            // org/sqlproc/engine/impl/SqlProcessor.g:364:12: (col= IDENT_DOT | col= IDENT )
                            int alt81=2;
                            switch ( input.LA(1) ) {
                            case IDENT_DOT:
                                {
                                alt81=1;
                                }
                                break;
                            case IDENT:
                                {
                                alt81=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 81, 0, input);

                                throw nvae;
                            }

                            switch (alt81) {
                                case 1 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:364:13: col= IDENT_DOT
                                    {
                                    col=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_mappingItem1891); 

                                    }
                                    break;
                                case 2 :
                                    // org/sqlproc/engine/impl/SqlProcessor.g:364:29: col= IDENT
                                    {
                                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1897); 

                                    }
                                    break;

                            }

                             if(!((mapping_scope)mapping_stack.peek()).skip) addColumnAttr(result, col); 
                            // org/sqlproc/engine/impl/SqlProcessor.g:365:5: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                            loop84:
                            do {
                                int alt84=2;
                                switch ( input.LA(1) ) {
                                case CARET:
                                    {
                                    alt84=1;
                                    }
                                    break;

                                }

                                switch (alt84) {
                            	case 1 :
                            	    // org/sqlproc/engine/impl/SqlProcessor.g:365:31: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                            	    {
                            	    match(input,CARET,FOLLOW_CARET_in_mappingItem1916); 
                            	    // org/sqlproc/engine/impl/SqlProcessor.g:365:37: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                            	    int alt83=2;
                            	    switch ( input.LA(1) ) {
                            	    case IDENT:
                            	        {
                            	        alt83=1;
                            	        }
                            	        break;
                            	    case NUMBER:
                            	        {
                            	        alt83=2;
                            	        }
                            	        break;
                            	    default:
                            	        NoViableAltException nvae =
                            	            new NoViableAltException("", 83, 0, input);

                            	        throw nvae;
                            	    }

                            	    switch (alt83) {
                            	        case 1 :
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:365:38: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                            	            {
                            	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1921); 
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:365:50: ( options {greedy=true; } : EQUALS value2= IDENT )?
                            	            int alt82=2;
                            	            switch ( input.LA(1) ) {
                            	                case EQUALS:
                            	                    {
                            	                    alt82=1;
                            	                    }
                            	                    break;
                            	            }

                            	            switch (alt82) {
                            	                case 1 :
                            	                    // org/sqlproc/engine/impl/SqlProcessor.g:365:75: EQUALS value2= IDENT
                            	                    {
                            	                    match(input,EQUALS,FOLLOW_EQUALS_in_mappingItem1932); 
                            	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_mappingItem1936); 

                            	                    }
                            	                    break;

                            	            }


                            	            }
                            	            break;
                            	        case 2 :
                            	            // org/sqlproc/engine/impl/SqlProcessor.g:365:99: value= NUMBER
                            	            {
                            	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_mappingItem1944); 

                            	            }
                            	            break;

                            	    }

                            	     if(!((mapping_scope)mapping_stack.peek()).skip) result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                            	    }
                            	    break;

                            	default :
                            	    break loop84;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "mappingItem"


    // $ANTLR start "option"
    // org/sqlproc/engine/impl/SqlProcessor.g:371:1: option[String name] returns [StringBuilder text] : (~ ( SEMICOLON ) )+ ;
    public final StringBuilder option(String name) throws RecognitionException {
        StringBuilder text = null;

        artifactName.push(name); text = new StringBuilder();
        try {
            // org/sqlproc/engine/impl/SqlProcessor.g:374:2: ( (~ ( SEMICOLON ) )+ )
            // org/sqlproc/engine/impl/SqlProcessor.g:374:4: (~ ( SEMICOLON ) )+
            {
            // org/sqlproc/engine/impl/SqlProcessor.g:374:4: (~ ( SEMICOLON ) )+
            int cnt87=0;
            loop87:
            do {
                int alt87=2;
                switch ( input.LA(1) ) {
                case WS:
                case IDENT:
                case LPAREN:
                case STATEMENT:
                case COMMA:
                case RPAREN:
                case EQUALS:
                case MAPPING:
                case OPTION:
                case COLON:
                case STRING:
                case AT:
                case PERCENT:
                case LBRACE:
                case RBRACE:
                case QUESTI:
                case BAND:
                case BOR:
                case HASH:
                case NUMBER:
                case AND:
                case OR:
                case NOT:
                case IDENT_DOT:
                case CARET:
                case PLUS:
                case MINUS:
                case LESS_THAN:
                case MORE_THAN:
                case DOT:
                case DIGIT:
                case ML_COMMENT:
                case SL_COMMENT:
                case ESC_COLON:
                case ESC_SEMICOLON:
                case ESC_STRING:
                case ESC_LBRACE:
                case ESC_RBRACE:
                case ESC_BOR:
                case ESC_HASH:
                case ESC_AT:
                case ESC_PERCENT:
                case ESC_DOT:
                case ESC_CHAR:
                case REST:
                    {
                    alt87=1;
                    }
                    break;

                }

                switch (alt87) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlProcessor.g:374:5: ~ ( SEMICOLON )
            	    {
            	    if ( (input.LA(1)>=WS && input.LA(1)<=EQUALS)||(input.LA(1)>=MAPPING && input.LA(1)<=REST) ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }

            	    add(text);

            	    }
            	    break;

            	default :
            	    if ( cnt87 >= 1 ) break loop87;
                        EarlyExitException eee =
                            new EarlyExitException(87, input);
                        throw eee;
                }
                cnt87++;
            } while (true);


            }

             artifactName.pop();
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return text;
    }
    // $ANTLR end "option"

    // Delegated rules


    protected DFA76 dfa76 = new DFA76(this);
    static final String DFA76_eotS =
        "\4\uffff";
    static final String DFA76_eofS =
        "\2\2\2\uffff";
    static final String DFA76_minS =
        "\2\4\2\uffff";
    static final String DFA76_maxS =
        "\1\13\1\30\2\uffff";
    static final String DFA76_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA76_specialS =
        "\4\uffff}>";
    static final String[] DFA76_transitionS = {
            "\1\1\6\uffff\1\2",
            "\1\1\1\3\5\uffff\1\2\14\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA76_eot = DFA.unpackEncodedString(DFA76_eotS);
    static final short[] DFA76_eof = DFA.unpackEncodedString(DFA76_eofS);
    static final char[] DFA76_min = DFA.unpackEncodedStringToUnsignedChars(DFA76_minS);
    static final char[] DFA76_max = DFA.unpackEncodedStringToUnsignedChars(DFA76_maxS);
    static final short[] DFA76_accept = DFA.unpackEncodedString(DFA76_acceptS);
    static final short[] DFA76_special = DFA.unpackEncodedString(DFA76_specialS);
    static final short[][] DFA76_transition;

    static {
        int numStates = DFA76_transitionS.length;
        DFA76_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA76_transition[i] = DFA.unpackEncodedString(DFA76_transitionS[i]);
        }
    }

    class DFA76 extends DFA {

        public DFA76(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 76;
            this.eot = DFA76_eot;
            this.eof = DFA76_eof;
            this.min = DFA76_min;
            this.max = DFA76_max;
            this.accept = DFA76_accept;
            this.special = DFA76_special;
            this.transition = DFA76_transition;
        }
        public String getDescription() {
            return "()* loopback of 354:3: ( ( WS )+ sqlMappingItem= mappingItem )*";
        }
    }
 

    public static final BitSet FOLLOW_WS_in_parse73 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse90 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse94 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_STATEMENT_in_parse98 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse103 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse107 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse113 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse115 = new BitSet(new long[]{0x0003FFFFFFFFF7F0L});
    public static final BitSet FOLLOW_meta_in_parse131 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse136 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse138 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse156 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse160 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_MAPPING_in_parse164 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse169 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse173 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse179 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse181 = new BitSet(new long[]{0x0000000001000030L});
    public static final BitSet FOLLOW_mapping_in_parse197 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse202 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse204 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_parse222 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_parse224 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_OPTION_in_parse228 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_COMMA_in_parse233 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_parse237 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_RPAREN_in_parse243 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_EQUALS_in_parse245 = new BitSet(new long[]{0x0003FFFFFFFFF7F0L});
    public static final BitSet FOLLOW_option_in_parse261 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_SEMICOLON_in_parse266 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_parse268 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_EOF_in_parse283 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sql_in_meta315 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EOF_in_meta318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_sql340 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql369 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_sql376 = new BitSet(new long[]{0x00000003D1000420L});
    public static final BitSet FOLLOW_identifier_in_sql380 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql387 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_sql399 = new BitSet(new long[]{0x00000000D0000020L});
    public static final BitSet FOLLOW_constant_in_sql403 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql415 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_sql427 = new BitSet(new long[]{0x0000000011000020L});
    public static final BitSet FOLLOW_column_in_sql431 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql443 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PERCENT_in_sql451 = new BitSet(new long[]{0x0000000010020020L});
    public static final BitSet FOLLOW_PERCENT_in_sql454 = new BitSet(new long[]{0x0000000010000020L});
    public static final BitSet FOLLOW_dbtable_in_sql458 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql462 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dbcolumn_in_sql484 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql488 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_sql501 = new BitSet(new long[]{0x0003FFFFFFF7FFF0L});
    public static final BitSet FOLLOW_metaSql_in_sql503 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_RBRACE_in_sql506 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});
    public static final BitSet FOLLOW_sql_in_sql508 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_metaSql535 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql566 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_metaSql575 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql579 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_QUESTI_in_metaSql591 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_metaSql597 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_BOR_in_metaSql604 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql608 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_metaSql617 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql621 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BAND_in_metaSql636 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql642 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_metaSql651 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql655 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_metaSql667 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql673 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_metaSql682 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql686 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_EQUALS_in_metaSql698 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_WS_in_metaSql700 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_in_metaSql705 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql711 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HASH_in_metaSql724 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_NUMBER_in_metaSql728 = new BitSet(new long[]{0x0003FFFFFFF7FFF0L});
    public static final BitSet FOLLOW_ordSql_in_metaSql732 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifSql763 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql796 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ifSql803 = new BitSet(new long[]{0x00000003D1000420L});
    public static final BitSet FOLLOW_identifier_in_ifSql807 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql814 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ifSql821 = new BitSet(new long[]{0x00000000D0000020L});
    public static final BitSet FOLLOW_constant_in_ifSql825 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql832 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_ifSql844 = new BitSet(new long[]{0x0000000011000020L});
    public static final BitSet FOLLOW_column_in_ifSql848 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql860 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PERCENT_in_ifSql867 = new BitSet(new long[]{0x0000000010020020L});
    public static final BitSet FOLLOW_PERCENT_in_ifSql870 = new BitSet(new long[]{0x0000000010000020L});
    public static final BitSet FOLLOW_dbtable_in_ifSql874 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql878 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dbcolumn_in_ifSql900 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql904 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_ifSql912 = new BitSet(new long[]{0x0003FFFFFFF3FFF0L});
    public static final BitSet FOLLOW_ifMetaSql_in_ifSql914 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_RBRACE_in_ifSql917 = new BitSet(new long[]{0x0003FFFFFFB7FFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql919 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifMetaSql947 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql974 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql983 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql987 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_QUESTI_in_ifMetaSql999 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifMetaSql1005 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1012 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1016 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1025 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1029 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BAND_in_ifMetaSql1044 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1050 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1059 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1063 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1075 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1081 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1090 = new BitSet(new long[]{0x0003FFFFFFB7FFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1094 = new BitSet(new long[]{0x0000000000400002L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1121 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1124 = new BitSet(new long[]{0x0000000006000012L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1127 = new BitSet(new long[]{0x0000000006000012L});
    public static final BitSet FOLLOW_AND_in_ifSqlCond1132 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_OR_in_ifSqlCond1138 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1143 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1148 = new BitSet(new long[]{0x0000000006000012L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1151 = new BitSet(new long[]{0x0000000006000012L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1171 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_COLON_in_ifSqlBool1174 = new BitSet(new long[]{0x00000003D1000420L});
    public static final BitSet FOLLOW_identifier_in_ifSqlBool1178 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1187 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_STRING_in_ifSqlBool1190 = new BitSet(new long[]{0x00000000D0000020L});
    public static final BitSet FOLLOW_constant_in_ifSqlBool1194 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1203 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_LPAREN_in_ifSqlBool1206 = new BitSet(new long[]{0x000000000800C050L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifSqlBool1210 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_RPAREN_in_ifSqlBool1212 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ordSql1236 = new BitSet(new long[]{0x0003FFFFFFF7FFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1257 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ordSql1264 = new BitSet(new long[]{0x00000003D1000420L});
    public static final BitSet FOLLOW_identifier_in_ordSql1268 = new BitSet(new long[]{0x0003FFFFFFF7FFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1275 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ordSql1282 = new BitSet(new long[]{0x00000000D0000020L});
    public static final BitSet FOLLOW_constant_in_ordSql1286 = new BitSet(new long[]{0x0003FFFFFFF7FFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PERCENT_in_ordSql1299 = new BitSet(new long[]{0x0000000010020020L});
    public static final BitSet FOLLOW_dbcolumn_in_ordSql1303 = new BitSet(new long[]{0x0003FFFFFFF7FFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1309 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_DOT_in_column1336 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_IDENT_in_column1342 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_column1348 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_column1364 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1368 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_column1384 = new BitSet(new long[]{0x0000000001000020L});
    public static final BitSet FOLLOW_IDENT_in_column1389 = new BitSet(new long[]{0x0000000020000402L});
    public static final BitSet FOLLOW_EQUALS_in_column1400 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1404 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_column1412 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_PLUS_in_constant1449 = new BitSet(new long[]{0x0000000010000020L});
    public static final BitSet FOLLOW_MINUS_in_constant1455 = new BitSet(new long[]{0x0000000010000020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_constant1462 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_IDENT_in_constant1468 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_constant1484 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1488 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_constant1504 = new BitSet(new long[]{0x0000000001000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1509 = new BitSet(new long[]{0x0000000020000402L});
    public static final BitSet FOLLOW_EQUALS_in_constant1520 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1524 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_constant1532 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_EQUALS_in_identifier1569 = new BitSet(new long[]{0x00000000D1000020L});
    public static final BitSet FOLLOW_LESS_THAN_in_identifier1575 = new BitSet(new long[]{0x00000000D1000020L});
    public static final BitSet FOLLOW_MORE_THAN_in_identifier1581 = new BitSet(new long[]{0x00000000D1000020L});
    public static final BitSet FOLLOW_PLUS_in_identifier1588 = new BitSet(new long[]{0x0000000011000020L});
    public static final BitSet FOLLOW_MINUS_in_identifier1594 = new BitSet(new long[]{0x0000000011000020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_identifier1601 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_IDENT_in_identifier1607 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_identifier1613 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_identifier1629 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1633 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_identifier1649 = new BitSet(new long[]{0x0000000001000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1654 = new BitSet(new long[]{0x0000000020000402L});
    public static final BitSet FOLLOW_EQUALS_in_identifier1665 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1669 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_identifier1677 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_IDENT_DOT_in_dbcolumn1714 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_dbcolumn1720 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_DOT_in_dbtable1747 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_dbtable1753 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WS_in_mapping1791 = new BitSet(new long[]{0x0000000001000030L});
    public static final BitSet FOLLOW_mappingItem_in_mapping1798 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_WS_in_mapping1805 = new BitSet(new long[]{0x0000000001000030L});
    public static final BitSet FOLLOW_mappingItem_in_mapping1810 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_WS_in_mapping1818 = new BitSet(new long[]{0x0000000000000012L});
    public static final BitSet FOLLOW_EOF_in_mapping1822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1848 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_NUMBER_in_mappingItem1854 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_STRING_in_mappingItem1871 = new BitSet(new long[]{0x0000000000008022L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1876 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_STRING_in_mappingItem1886 = new BitSet(new long[]{0x0000000010000020L});
    public static final BitSet FOLLOW_IDENT_DOT_in_mappingItem1891 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1897 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_CARET_in_mappingItem1916 = new BitSet(new long[]{0x0000000001000020L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1921 = new BitSet(new long[]{0x0000000020000402L});
    public static final BitSet FOLLOW_EQUALS_in_mappingItem1932 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_mappingItem1936 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_NUMBER_in_mappingItem1944 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_set_in_option1996 = new BitSet(new long[]{0x0003FFFFFFFFF7F2L});

}