/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMetaIdent
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Code caseConversion;
    private SqlInputValue.Mode inOutMode;
    private boolean not;
    private List<String> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode) {
        this(caseConversion, inOutMode, false);
    }

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode, boolean not) {
        this(caseConversion, inOutMode, false, new SqlType());
    }

    SqlMetaIdent(SqlInputValue.Code caseConversion, SqlInputValue.Mode inOutMode, boolean not, SqlType type) {
        this.elements = new ArrayList<String>();
        this.caseConversion = caseConversion;
        this.inOutMode = inOutMode;
        this.not = not;
        this.sqlType = type;
    }

    void addIdent(String name) {
        String[] names = name.split("=");
        this.elements.add(names[0]);
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if (value.equals("idsel")) {
                this.values.put(value, "idsel");
            } else if (value.equals("seq")) {
                this.values.put(value, "seq");
            } else {
                this.sqlType.setValue(value);
            }
        } else {
            this.values.put(value, value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlInputValue identityInputValue;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> process : dynamicInputValues=" + ctx.dynamicInputValues + ", class=" + (ctx.dynamicInputValues != null ? ctx.dynamicInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        SqlProcessResult result = new SqlProcessResult();
        Object obj = ctx.dynamicInputValues;
        Object parentObj = null;
        StringBuilder s = new StringBuilder(this.elements.size() * 32);
        s.append(':');
        int count = 1;
        String sequenceName = this.values.get("seq");
        String identitySelectName = this.values.get("idsel");
        String attributeName = null;
        Class<?> attributeType = obj != null ? obj.getClass() : null;
        for (String item : this.elements) {
            attributeName = item;
            if (Character.isDigit(attributeName.charAt(0))) {
                s.append(attributeName);
                if (obj == null) break;
                parentObj = obj;
                obj = null;
                break;
            }
            if (attributeType != null) {
                Class<?> origAttributeType = attributeType;
                if ((attributeType = BeanUtils.getFieldType(attributeType, attributeName)) == null) {
                    if (SqlProcessContext.isFeature("IGNORE_INPROPER_IN")) {
                        this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    } else {
                        throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    }
                }
            }
            if (count > 1) {
                s.append('_');
            }
            s.append(attributeName);
            if (obj != null) {
                parentObj = obj;
                obj = BeanUtils.getProperty(obj, item);
            }
            ++count;
        }
        if (sequenceName != null) {
            String sequence = SqlUtils.sequence(sequenceName);
            if (sequence == null) {
                throw new SqlRuntimeException("Missing sequence " + sequenceName);
            }
            result.add(true);
            identityInputValue = new SqlInputValue(SqlInputValue.Type.SEQUENCE_BASED, obj, parentObj, attributeType, sequence, this.sqlType);
            result.addInputValue(s.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
            result.setSql(new StringBuilder(SqlProcessContext.isFeature("JDBC") ? "?" : s.toString()));
        } else if (identitySelectName != null) {
            String identitySelect = SqlUtils.identitySelect(identitySelectName);
            if (identitySelect == null) {
                throw new SqlRuntimeException("Missing identity select " + identitySelectName);
            }
            result.add(true);
            identityInputValue = new SqlInputValue(SqlInputValue.Type.IDENTITY_SELECT, obj, parentObj, attributeType, identitySelect, this.sqlType);
            result.addInputValue(s.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
            result.setSkipNextText(true);
        } else {
            try {
                result.add(SqlUtils.isEmpty(obj, this.sqlType, ctx.inSqlSetOrInsert || ctx.sqlStatementType == SqlMetaStatement.Type.CALL));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
            }
            if (obj != null && obj instanceof Collection) {
                boolean notEmpty = !((Collection)obj).isEmpty();
                StringBuilder ss = new StringBuilder(notEmpty ? "(" : "");
                int i = 1;
                Iterator iter = ((Collection)obj).iterator();
                while (iter.hasNext()) {
                    Object objItem = iter.next();
                    if (objItem != null) {
                        String attributeNameItem = s.toString() + "_" + i++;
                        ss.append(SqlProcessContext.isFeature("JDBC") ? "?" : attributeNameItem);
                        result.addInputValue(attributeNameItem.substring(1), new SqlInputValue(SqlInputValue.Type.PROVIDED, objItem, parentObj, objItem.getClass(), this.caseConversion, this.inOutMode, this.sqlType));
                    } else {
                        ss.append("null");
                    }
                    if (!iter.hasNext()) continue;
                    ss.append(',');
                }
                if (notEmpty) {
                    ss.append(')');
                }
                result.setSql(ss);
            } else {
                SqlInputValue sqlInputValue = new SqlInputValue(SqlInputValue.Type.PROVIDED, obj, parentObj, attributeType, this.caseConversion, this.inOutMode, this.sqlType);
                result.addInputValue(s.substring(1), sqlInputValue);
                if (this.inOutMode == SqlInputValue.Mode.OUT || this.inOutMode == SqlInputValue.Mode.INOUT) {
                    result.addOutValue(attributeName, sqlInputValue);
                }
                result.setSql(new StringBuilder(SqlProcessContext.isFeature("JDBC") ? "?" : s.toString()));
            }
        }
        return result;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : dynamicInputValues=" + ctx.dynamicInputValues + ", class=" + (ctx.dynamicInputValues != null ? ctx.dynamicInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object obj = ctx.dynamicInputValues;
        for (String item : this.elements) {
            if (obj == null) continue;
            obj = BeanUtils.getProperty(obj, item);
        }
        boolean result = SqlUtils.isTrue(obj, this.sqlType);
        return this.not ? !result : result;
    }
}

