/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidationException;

public class SqlCrudEngine
extends SqlEngine {
    public SqlCrudEngine(String name, String statement, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), null, null, null, typeFactory, pluginFactory, null);
    }

    public SqlCrudEngine(String name, String statement, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), null, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, null, null, null, typeFactory, pluginFactory, null);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, null, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, null);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, SqlEngineConfiguration configuration) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory, configuration);
    }

    public int insert(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.insert(session, dynamicInputValues, null);
    }

    public int insert(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.insert(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int insert(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.insert(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException, SqlValidationException {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> insert, session=" + String.valueOf(session) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
            sqlControl.getSqlExecutionCallback().handleInputValues(dynamicInputValues);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.CREATE, dynamicInputValues, sqlControl);
                    processResult.validate(SqlCrudEngine.this.validator);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    sql = SqlUtils.handleInsertSql(processResult.getIdentities(), sql);
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    if (!processResult.setQueryParams(session, query) && SqlEngine.isSkipEmptyStatement(sqlControl)) {
                        return 0;
                    }
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.insert(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.insert(query, processResult);
                }
            }, Integer.class);
            if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
                sqlControl.getSqlExecutionCallback().handleOutputValues(dynamicInputValues);
            }
            n = count;
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< insert, result=" + count);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< insert, result=" + count);
        }
        return n;
    }

    private Integer insert(SqlQuery query, SqlProcessResult processResult) {
        Integer count = query.update(processResult.getRuntimeContext());
        processResult.postProcess();
        return count;
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)null);
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMoreResultClasses(moreResultClasses));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout).setMoreResultClasses(moreResultClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E get(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> get, session=" + String.valueOf(session) + ", resultClass=" + String.valueOf(resultClass) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
            sqlControl.getSqlExecutionCallback().handleInputValues(dynamicInputValues);
        }
        E result = null;
        try {
            E e = result = (E)this.monitor.run(new SqlMonitor.Runner(){

                public E run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.RETRIEVE, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    processResult.setQueryParams(session, query);
                    final SqlMappingResult mappingResult = SqlMappingRule.merge(SqlCrudEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, SqlEngine.getMoreResultClasses(sqlControl), query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            public E run() {
                                return SqlCrudEngine.this.get(query, mappingResult, resultClass, sqlControl);
                            }
                        }, resultClass);
                    }
                    return SqlCrudEngine.this.get(query, mappingResult, resultClass, sqlControl);
                }
            }, resultClass);
            return e;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< get, result=" + String.valueOf(result));
            }
        }
    }

    private <E> E get(SqlQuery query, SqlMappingResult mappingResult, Class<E> resultClass, SqlControl sqlControl) {
        List<Map<String, Object>> list = query.list(mappingResult.getRuntimeContext());
        Object resultInstance = null;
        Object[] resultValues = null;
        Map<String, Object> ids = mappingResult.getIds();
        for (Map<String, Object> resultRow : list) {
            String idsKey;
            resultValues = SqlUtils.getResultValues(resultRow);
            boolean changedIdentity = true;
            if (ids != null && ids.containsKey(idsKey = SqlUtils.getIdsKey(resultValues, mappingResult.getMainIdentityIndex()))) {
                changedIdentity = false;
            }
            if (changedIdentity) {
                if (resultInstance != null) {
                    throw new SqlProcessorException("There's no unique result");
                }
                resultInstance = mappingResult.getRuntimeContext().getInstance(resultClass);
                if (resultInstance == null) {
                    throw new SqlRuntimeException("There's problem to instantiate " + String.valueOf(resultClass));
                }
            }
            mappingResult.setQueryResultData(resultInstance, resultValues, ids, SqlCrudEngine.getMoreResultClasses(sqlControl));
            if (!changedIdentity) continue;
            if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
                sqlControl.getSqlExecutionCallback().handleOutputValues(resultInstance);
            }
            if (ids == null) continue;
            idsKey = SqlUtils.getIdsKey(resultValues, mappingResult.getMainIdentityIndex());
            ids.put(idsKey, resultInstance);
        }
        return (E)resultInstance;
    }

    public int update(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.update(session, dynamicInputValues, null);
    }

    public int update(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.update(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int update(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.update(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException, SqlValidationException {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> update, session=" + String.valueOf(session) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
            sqlControl.getSqlExecutionCallback().handleInputValues(dynamicInputValues);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.UPDATE, dynamicInputValues, sqlControl);
                    processResult.validate(SqlCrudEngine.this.validator);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    if (!processResult.setQueryParams(session, query) && SqlEngine.isSkipEmptyStatement(sqlControl)) {
                        return 0;
                    }
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.update(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.update(query, processResult);
                }
            }, Integer.class);
            if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
                sqlControl.getSqlExecutionCallback().handleOutputValues(dynamicInputValues);
            }
            n = count;
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< update, result=" + count);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< update, result=" + count);
        }
        return n;
    }

    private Integer update(SqlQuery query, SqlProcessResult processResult) {
        return query.update(processResult.getRuntimeContext());
    }

    public int delete(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.delete(session, dynamicInputValues, null);
    }

    public int delete(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.delete(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int delete(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.delete(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> delete, session=" + String.valueOf(session) + ", dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
            sqlControl.getSqlExecutionCallback().handleInputValues(dynamicInputValues);
        }
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.DELETE, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    query.setSqlControl(sqlControl);
                    processResult.setQueryParams(session, query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.delete(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.delete(query, processResult);
                }
            }, Integer.class);
            if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
                sqlControl.getSqlExecutionCallback().handleOutputValues(dynamicInputValues);
            }
            n = count;
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< delete, result=" + count);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< delete, result=" + count);
        }
        return n;
    }

    private Integer delete(SqlQuery query, SqlProcessResult processResult) {
        return query.update(processResult.getRuntimeContext());
    }

    public String getInsertSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CREATE);
    }

    public String getGetSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.RETRIEVE);
    }

    public String getUpdateSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.UPDATE);
    }

    public String getDeleteSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.DELETE);
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues), statementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl, final SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        String string;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + String.valueOf(dynamicInputValues) + ", sqlControl=" + String.valueOf(sqlControl));
        }
        this.checkDynamicInputValues(dynamicInputValues);
        if (sqlControl != null && sqlControl.getSqlExecutionCallback() != null) {
            sqlControl.getSqlExecutionCallback().handleInputValues(dynamicInputValues);
        }
        String sql = null;
        try {
            string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.process(statementType, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
            throw throwable;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("<< getSql, sql=" + sql);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

