/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.filter.LoggingFilter;

public class RestClient
implements Closeable {
    public static final String REST_APPIUM_PATH = "/rest/appium/v1/";
    public static final String REST_DEVICES_PATH = "/rest/devices/v1/";
    private final Client client;
    private final WebTarget target;

    RestClient(Client client, WebTarget target) {
        this.client = client;
        this.target = target;
    }

    public WebTarget path(String path) {
        return this.target.path(path);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static final class Builder {
        private Client client;
        private String baseUrl;
        private String path = "";
        private String token = "";

        public static Builder createClient() {
            return new Builder();
        }

        private static void addProxyConfiguration(ClientConfig config, String baseUrl) {
            String protocol = URI.create(baseUrl).getScheme().toLowerCase();
            Optional proxyHost = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyHost"));
            if (!proxyHost.isPresent()) {
                return;
            }
            String host = (String)proxyHost.get();
            String port = (String)Optional.fromNullable((Object)System.getProperty(protocol + ".proxyPort")).or((Object)"8080");
            String proxyProtocol = (String)Optional.fromNullable((Object)System.getProperty(protocol + ".proxyProtocol")).or((Object)"http");
            String url = proxyProtocol + "://" + host + ":" + port;
            config.property("jersey.config.client.proxy.uri", (Object)url);
            Optional username = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyUser"));
            Optional password = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyPassword"));
            if (username.isPresent() && password.isPresent()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)username.get(), (String)password.get());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            }
        }

        public Builder withUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public RestClient build() {
            ClientConfig config = new ClientConfig();
            config.property("jersey.config.apache.client.handleCookies", (Object)false);
            Builder.addProxyConfiguration(config, this.baseUrl);
            this.client = ClientBuilder.newClient((Configuration)config);
            this.client.register(LoggingFilter.class);
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basicBuilder().nonPreemptive().credentials(this.token, "").build();
            this.client.register((Object)feature);
            WebTarget target = this.client.target(this.baseUrl + this.path);
            return new RestClient(this.client, target);
        }
    }
}

