/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.testobject.api.TestObjectClient;
import org.testobject.external.apache.http.config.Registry;
import org.testobject.external.apache.http.config.RegistryBuilder;
import org.testobject.external.apache.http.conn.socket.ConnectionSocketFactory;
import org.testobject.external.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.X509HostnameVerifier;
import org.testobject.external.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testobject.rest.api.AppVersionResourceImpl;
import org.testobject.rest.api.DeviceDescriptorsResourceImpl;
import org.testobject.rest.api.QualityReportResourceImpl;
import org.testobject.rest.api.SessionReportResourceImpl;
import org.testobject.rest.api.TestReportResourceImpl;
import org.testobject.rest.api.TestSuiteReportResourceImpl;
import org.testobject.rest.api.TestSuiteResourceImpl;
import org.testobject.rest.api.UploadResourceImpl;
import org.testobject.rest.api.VideoResourceImpl;
import org.testobject.rest.api.model.AppiumTestReport;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.model.PaginationObject;
import org.testobject.rest.api.model.SessionReport;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.AppVersionResource;
import org.testobject.rest.api.resource.DeviceDescriptorsResource;
import org.testobject.rest.api.resource.QualityReportResource;
import org.testobject.rest.api.resource.SessionReportResource;
import org.testobject.rest.api.resource.TestReportResource;
import org.testobject.rest.api.resource.TestSuiteReportResource;
import org.testobject.rest.api.resource.TestSuiteResource;
import org.testobject.rest.api.resource.UploadResource;

public class TestObjectRemoteClient
implements TestObjectClient {
    private final UploadResource upload;
    private final AppVersionResource appVersion;
    private final TestSuiteResource testSuite;
    private final TestSuiteReportResource testSuiteReport;
    private final QualityReportResource qualityReport;
    private final SessionReportResource sessionReport;
    private final DeviceDescriptorsResource deviceDescriptors;
    private final TestReportResource testReportResource;
    private final VideoResourceImpl videoResource;
    private final Client client;

    public TestObjectRemoteClient(String baseUrl, TestObjectClient.ProxySettings proxySettings) {
        X509HostnameVerifier defaultHostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslConfig.createSSLContext(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, defaultHostnameVerifier);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.apache.client.connectionManager", new PoolingHttpClientConnectionManager(registry));
        ApacheConnectorProvider connector = new ApacheConnectorProvider();
        config.connectorProvider(connector);
        config.register((Class)MultiPartFeature.class);
        config.register((Class)JacksonFeature.class);
        if (proxySettings != null) {
            config.getProperties().put("jersey.config.client.proxy.uri", "http://" + proxySettings.getHost() + ":" + proxySettings.getPort());
            if (proxySettings.getUsername() != null) {
                config.getProperties().put("jersey.config.client.proxy.username", proxySettings.getUsername());
                config.getProperties().put("jersey.config.client.proxy.password", proxySettings.getPassword());
            }
        }
        SSLContext sslContext = sslConfig.createSSLContext();
        ClientBuilder.newBuilder().sslContext(sslContext);
        this.client = ClientBuilder.newClient(config);
        WebTarget resource = this.client.target(baseUrl);
        this.upload = new UploadResourceImpl(resource);
        this.appVersion = new AppVersionResourceImpl(resource);
        this.testSuite = new TestSuiteResourceImpl(resource);
        this.testSuiteReport = new TestSuiteReportResourceImpl(resource);
        this.qualityReport = new QualityReportResourceImpl(resource);
        this.deviceDescriptors = new DeviceDescriptorsResourceImpl(resource);
        this.sessionReport = new SessionReportResourceImpl(resource);
        this.testReportResource = new TestReportResourceImpl(resource);
        this.videoResource = new VideoResourceImpl(resource);
    }

    @Override
    public void updateInstrumentationTestSuite(String user, String project, long testSuite, File appApk, File testApk, TestSuiteResource.InstrumentationTestSuiteRequest request) {
        String testUploadId;
        String appUploadId = this.upload.uploadFile(user, project, appApk).replace("\"", "");
        request.testUploadId = testUploadId = this.upload.uploadFile(user, project, testApk).replace("\"", "");
        request.appUploadId = appUploadId;
        this.testSuite.updateInstrumentationTestSuite(user, project, testSuite, request);
    }

    @Override
    public Long createInstrumentationTestSuite(String user, String project, long testSuite, File appApk, File testApk, TestSuiteResource.InstrumentationTestSuiteRequest instrumentationTestSuiteRequest) {
        String appUploadId = this.upload.uploadFile(user, project, appApk).replace("\"", "");
        String testUploadId = this.upload.uploadFile(user, project, testApk).replace("\"", "");
        instrumentationTestSuiteRequest.appUploadId = appUploadId;
        instrumentationTestSuiteRequest.testUploadId = testUploadId;
        return this.testSuite.createInstrumentationTestSuite(user, project, testSuite, instrumentationTestSuiteRequest);
    }

    @Override
    public long startInstrumentationTestSuite(String user, String project, long testSuite) {
        return this.testSuite.runInstrumentationTestSuite(user, project, testSuite);
    }

    @Override
    public TestSuiteReport waitForSuiteReport(String user, String project, long testSuiteReportId) {
        return this.waitForSuiteReport(user, project, testSuiteReportId, TimeUnit.MINUTES.toMillis(60L), TimeUnit.SECONDS.toMillis(30L));
    }

    @Override
    public TestSuiteReport waitForSuiteReport(String user, String project, long testSuiteReportId, long waitTimeoutMs, long sleepTimeMs) {
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            TestSuiteReport testSuiteReport = this.testSuiteReport.getReport(user, project, testSuiteReportId, "application/json");
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        throw new IllegalStateException("unable to get test suite report result after 60min");
    }

    @Override
    public void createAppVersion(String userId, String projectId, File appApk) {
        String appUploadId = this.upload.uploadFile(userId, projectId, appApk).replace("\"", "");
        this.appVersion.createAppVersion(userId, projectId, new AppVersionResource.CreateAppVersionRequest(appUploadId));
    }

    @Override
    public long startQualityReport(String userId, String projectId) {
        return this.qualityReport.startQualityReport(userId, projectId);
    }

    @Override
    public PaginationObject<SessionReport> getSessionReport(String user) {
        return this.sessionReport.getSessionReport(user);
    }

    @Override
    public PaginationObject<SessionReport> getSessionReport(String user, String userId, long offset, int limit, int lastDays) {
        return this.sessionReport.getSessionReport(user, userId, offset, limit, lastDays);
    }

    @Override
    public List<DeviceDescriptor> listDevices() {
        return this.deviceDescriptors.listDevices();
    }

    @Override
    public AppiumTestReport getTestReport(String user, String project, long reportId) {
        return this.testReportResource.getTestReport(user, project, reportId).getReport();
    }

    @Override
    public File saveVideo(String user, String project, String videoId, File file) {
        try (InputStream inputStream = this.videoResource.getScreenRecording(user, project, videoId).readEntity(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save video", e);
        }
        return file;
    }

    private void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.client.close();
    }
}

