/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.testobject.api.InvalidUserInputServerException;
import org.testobject.api.ProxySettings;
import org.testobject.api.TestObjectClientImpl;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.PaginationObject;
import org.testobject.rest.api.model.SessionReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;
import org.testobject.rest.api.model.TestReportWithDevice;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.v2.ApiBatchResource;

public interface TestObjectClient
extends Closeable {
    public TestSuiteReport waitForSuiteReport(long var1, long var3, long var5, String var7);

    public TestSuiteReport waitForSuiteReport(long var1, String var3);

    public String readTestSuiteXMLReport(long var1, String var3);

    public long startInstrumentationTestSuite(long var1, String var3);

    public void updateInstrumentationTestSuite(long var1, File var3, File var4, ApiBatchResource.InstrumentationTestSuiteRequest var5, String var6);

    public TestReportWithDevice getTestReport(long var1, String var3);

    public String uploadFile(String var1, File var2);

    public File saveScreenRecording(String var1, String var2, File var3);

    public long uploadRunnerIpa(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadAppIpa(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadRunnerApk(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadAppApk(String var1, File var2) throws InvalidUserInputServerException;

    public StartInstrumentationResponse startXcuiTestSuite(String var1, StaticInstrumentationRequestData var2);

    public StartInstrumentationResponse startXcuiTestSuite(String var1, DynamicInstrumentationRequestData var2);

    public StartInstrumentationResponse startAndroidSuite(String var1, StaticInstrumentationRequestData var2);

    public StartInstrumentationResponse startAndroidSuite(String var1, DynamicInstrumentationRequestData var2);

    public String readJunitReport(String var1, long var2);

    public String readJunitReport(String var1, List<Long> var2);

    public InstrumentationReport waitForInstrumentationReport(String var1, long var2, long var4, long var6) throws TimeoutException;

    public PaginationObject<SessionReport> getSessionReports(String var1, long var2, int var4, int var5, String var6);

    public List<DeviceDescriptor> getAvailableDeviceDescriptors();

    public List<String> getAvailableDeviceDescriptorIds();

    @Override
    public void close();

    public static final class Factory {
        private static final String BASE_URL = "https://appium.testobject.com/api/rest";

        public static TestObjectClient create() {
            return Factory.create(BASE_URL, null);
        }

        public static TestObjectClient create(String baseUrl) {
            return Factory.create(baseUrl, null);
        }

        public static TestObjectClient create(String baseUrl, ProxySettings proxySettings) {
            return new TestObjectClientImpl(baseUrl, proxySettings);
        }
    }
}

