/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ApiBatchResource {
    private final WebTarget target;

    public ApiBatchResource(WebTarget target) {
        this.target = target;
    }

    public long startInstrumentationSuite(long testSuite, String apiKey) {
        String apiKeyHeader = "Basic " + Base64.getEncoder().encodeToString((":" + apiKey).getBytes());
        return this.target.path("v2").path("batches").path("instrumentation").path(Long.toString(testSuite)).path("replay").request("application/json").header("Authorization", apiKeyHeader).post(Entity.json(null), Long.class);
    }

    public void updateInstrumentationSuite(long testSuite, InstrumentationTestSuiteRequest request, String apiKey) {
        String apiKeyHeader = "Basic " + Base64.getEncoder().encodeToString((":" + apiKey).getBytes());
        Response response = this.target.path("v2").path("batches").path("instrumentation").path(Long.toString(testSuite)).request("application/json").header("Authorization", apiKeyHeader).put(Entity.entity(request, "application/json"));
        if (Response.Status.NO_CONTENT.getStatusCode() != response.getStatus()) {
            throw new IllegalStateException("expected status " + Response.Status.NO_CONTENT + " but was " + response.getStatus());
        }
    }

    public class InstrumentationTestSuiteRequest {
        @JsonProperty
        public String appUploadId;
        @JsonProperty
        public String testUploadId;
        @JsonProperty
        public List<String> methodsToRun;
        @JsonProperty
        public List<String> classesToRun;
        @JsonProperty
        public List<String> annotationsToRun;
        @JsonProperty
        public List<String> sizesToRun;
        @JsonProperty
        public String tunnelIdentifier;
        @JsonProperty
        public boolean runAsPackage;

        private InstrumentationTestSuiteRequest() {
        }

        public InstrumentationTestSuiteRequest(String appUploadId, String testUploadId) {
            this.appUploadId = appUploadId;
            this.testUploadId = testUploadId;
        }

        public InstrumentationTestSuiteRequest(boolean runAsPackage) {
            this.runAsPackage = runAsPackage;
        }
    }
}

